/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.component;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.KeyType;
import org.sonar.db.protobuf.DbProjectBranches;

public class BranchDto {
    public static final String DEFAULT_MAIN_BRANCH_NAME = "master";
    public static final int KEE_MAX_LENGTH = 255;
    private String uuid;
    private String projectUuid;
    private String kee;
    private KeyType keyType;
    private BranchType branchType;
    @Nullable
    private String mergeBranchUuid;
    @Nullable
    private byte[] pullRequestBinary;
    @Nullable
    private String manualBaseline;

    public String getUuid() {
        return this.uuid;
    }

    public BranchDto setUuid(String s) {
        this.uuid = s;
        return this;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public BranchDto setProjectUuid(String s) {
        this.projectUuid = s;
        return this;
    }

    public boolean isMain() {
        return this.projectUuid.equals(this.uuid);
    }

    private String getKee() {
        return this.kee;
    }

    public String getKey() {
        return this.kee;
    }

    private void setKee(String s) {
        this.kee = s;
    }

    public BranchDto setKey(String s) {
        Preconditions.checkArgument((s.length() <= 255 ? 1 : 0) != 0, (String)"Maximum length of branch name or pull request id is %s: %s", (Object[])new Object[]{255, s});
        this.setKee(s);
        return this;
    }

    BranchDto setKeyType(KeyType keyType) {
        this.keyType = keyType;
        return this;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public BranchDto setBranchType(BranchType b) {
        this.branchType = b;
        return this;
    }

    @Nullable
    public String getMergeBranchUuid() {
        return this.mergeBranchUuid;
    }

    public BranchDto setMergeBranchUuid(@Nullable String s) {
        this.mergeBranchUuid = s;
        return this;
    }

    public BranchDto setPullRequestData(DbProjectBranches.PullRequestData pullRequestData) {
        this.pullRequestBinary = BranchDto.encodePullRequestData(pullRequestData);
        return this;
    }

    @CheckForNull
    public DbProjectBranches.PullRequestData getPullRequestData() {
        if (this.pullRequestBinary == null) {
            return null;
        }
        return BranchDto.decodePullRequestData(this.pullRequestBinary);
    }

    private static byte[] encodePullRequestData(DbProjectBranches.PullRequestData pullRequestData) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            pullRequestData.writeTo(outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to serialize pull request data", e);
        }
    }

    private static DbProjectBranches.PullRequestData decodePullRequestData(byte[] pullRequestBinary) {
        DbProjectBranches.PullRequestData pullRequestData;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(pullRequestBinary);
        try {
            pullRequestData = DbProjectBranches.PullRequestData.parseFrom(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to deserialize pull request data", e);
            }
        }
        inputStream.close();
        return pullRequestData;
    }

    @CheckForNull
    public String getManualBaseline() {
        return this.manualBaseline;
    }

    public BranchDto setManualBaseline(@Nullable String manualBaseline) {
        this.manualBaseline = manualBaseline == null || manualBaseline.isEmpty() ? null : manualBaseline;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BranchDto branchDto = (BranchDto)o;
        return Objects.equals(this.uuid, branchDto.uuid) && Objects.equals(this.projectUuid, branchDto.projectUuid) && Objects.equals(this.kee, branchDto.kee) && this.branchType == branchDto.branchType && Objects.equals(this.mergeBranchUuid, branchDto.mergeBranchUuid) && Objects.equals(this.manualBaseline, branchDto.manualBaseline);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uuid, this.projectUuid, this.kee, this.branchType, this.mergeBranchUuid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BranchDto{");
        sb.append("uuid='").append(this.uuid).append('\'');
        sb.append(", projectUuid='").append(this.projectUuid).append('\'');
        sb.append(", kee='").append(this.kee).append('\'');
        sb.append(", keyType=").append((Object)this.keyType);
        sb.append(", branchType=").append((Object)this.branchType);
        sb.append(", mergeBranchUuid='").append(this.mergeBranchUuid).append('\'');
        sb.append(", manualBaseline='").append(this.manualBaseline).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

