/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.db.DaoUtils;
import org.sonar.db.WildcardPosition;
import org.sonar.db.component.ComponentDto;

public class MeasureTreeQuery {
    @CheckForNull
    private final String nameOrKeyQuery;
    @CheckForNull
    private final Collection<String> qualifiers;
    private final Strategy strategy;
    @CheckForNull
    private final Collection<Integer> metricIds;

    private MeasureTreeQuery(Builder builder) {
        this.nameOrKeyQuery = builder.nameOrKeyQuery;
        this.qualifiers = builder.qualifiers == null ? null : Lists.newArrayList((Iterable)builder.qualifiers);
        this.strategy = Objects.requireNonNull(builder.strategy);
        this.metricIds = builder.metricIds;
    }

    @CheckForNull
    public String getNameOrKeyQuery() {
        return this.nameOrKeyQuery;
    }

    @CheckForNull
    public String getNameOrKeyUpperLikeQuery() {
        return this.nameOrKeyQuery == null ? null : DaoUtils.buildLikeValue(this.nameOrKeyQuery, WildcardPosition.BEFORE_AND_AFTER).toUpperCase(Locale.ENGLISH);
    }

    @CheckForNull
    public Collection<String> getQualifiers() {
        return this.qualifiers;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    @CheckForNull
    public Collection<Integer> getMetricIds() {
        return this.metricIds;
    }

    public String getUuidPath(ComponentDto component) {
        switch (this.strategy) {
            case CHILDREN: {
                return component.getUuidPath() + component.uuid() + ".";
            }
            case LEAVES: {
                return DaoUtils.buildLikeValue(component.getUuidPath() + component.uuid() + ".", WildcardPosition.AFTER);
            }
        }
        throw new IllegalArgumentException("Unknown strategy : " + (Object)((Object)this.strategy));
    }

    public boolean returnsEmpty() {
        return this.metricIds != null && this.metricIds.isEmpty() || this.qualifiers != null && this.qualifiers.isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @CheckForNull
        private String nameOrKeyQuery;
        @CheckForNull
        private Collection<String> qualifiers;
        private Strategy strategy;
        @CheckForNull
        private Collection<Integer> metricIds;

        private Builder() {
        }

        public Builder setNameOrKeyQuery(@Nullable String nameOrKeyQuery) {
            this.nameOrKeyQuery = nameOrKeyQuery;
            return this;
        }

        public Builder setQualifiers(Collection<String> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder setStrategy(Strategy strategy) {
            this.strategy = Objects.requireNonNull(strategy);
            return this;
        }

        public Builder setMetricIds(@Nullable Collection<Integer> metricIds) {
            this.metricIds = metricIds;
            return this;
        }

        public MeasureTreeQuery build() {
            return new MeasureTreeQuery(this);
        }
    }

    public static enum Strategy {
        CHILDREN,
        LEAVES;

    }
}

