/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.measure;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SumNclocDbQuery {
    private final String projectUuidToExclude;
    private final String organizationUuid;
    private final Boolean onlyPrivateProjects;

    public SumNclocDbQuery(Builder builder) {
        this.projectUuidToExclude = builder.projectUuidToExclude;
        this.organizationUuid = builder.organizationUuid;
        this.onlyPrivateProjects = builder.onlyPrivateProjects;
    }

    @CheckForNull
    public String getProjectUuidToExclude() {
        return this.projectUuidToExclude;
    }

    public String getOrganizationUuid() {
        return this.organizationUuid;
    }

    public Boolean getOnlyPrivateProjects() {
        return this.onlyPrivateProjects;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String projectUuidToExclude;
        private String organizationUuid;
        private Boolean onlyPrivateProjects;

        private Builder() {
        }

        public Builder setProjectUuidToExclude(@Nullable String projectUuidToExclude) {
            this.projectUuidToExclude = projectUuidToExclude;
            return this;
        }

        public Builder setOrganizationUuid(String organizationUuid) {
            this.organizationUuid = organizationUuid;
            return this;
        }

        public Builder setOnlyPrivateProjects(Boolean onlyPrivateProjects) {
            this.onlyPrivateProjects = onlyPrivateProjects;
            return this;
        }

        public SumNclocDbQuery build() {
            Preconditions.checkNotNull((Object)this.organizationUuid);
            Preconditions.checkNotNull((Object)this.onlyPrivateProjects);
            return new SumNclocDbQuery(this);
        }
    }
}

