/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.metric;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.metric.MetricMapper;

public class MetricDao
implements Dao {
    @CheckForNull
    public MetricDto selectByKey(DbSession session, String key) {
        return MetricDao.mapper(session).selectByKey(key);
    }

    public List<MetricDto> selectByKeys(DbSession session, Collection<String> keys) {
        return DatabaseUtils.executeLargeInputs(keys, MetricDao.mapper(session)::selectByKeys);
    }

    public MetricDto selectOrFailByKey(DbSession session, String key) {
        MetricDto metric = this.selectByKey(session, key);
        if (metric == null) {
            throw new RowNotFoundException(String.format("Metric key '%s' not found", key));
        }
        return metric;
    }

    public List<MetricDto> selectAll(DbSession session) {
        return MetricDao.mapper(session).selectAll();
    }

    public List<MetricDto> selectEnabled(DbSession session) {
        return MetricDao.mapper(session).selectAllEnabled();
    }

    public List<MetricDto> selectEnabled(DbSession session, @Nullable Boolean isCustom, int offset, int limit) {
        HashMap properties = Maps.newHashMapWithExpectedSize((int)1);
        if (isCustom != null) {
            properties.put("isCustom", isCustom);
        }
        return MetricDao.mapper(session).selectAllEnabled(properties, new RowBounds(offset, limit));
    }

    public int countEnabled(DbSession session, @Nullable Boolean isCustom) {
        return MetricDao.mapper(session).countEnabled(isCustom);
    }

    public MetricDto insert(DbSession session, MetricDto dto) {
        MetricDao.mapper(session).insert(dto);
        return dto;
    }

    public void insert(DbSession session, Collection<MetricDto> items) {
        for (MetricDto item : items) {
            this.insert(session, item);
        }
    }

    public void insert(DbSession session, MetricDto item, MetricDto ... others) {
        this.insert(session, Lists.asList((Object)item, (Object[])others));
    }

    public List<String> selectEnabledDomains(DbSession session) {
        return Lists.newArrayList((Iterable)Collections2.filter(MetricDao.mapper(session).selectDomains(), (Predicate)new NotEmptyPredicate()));
    }

    public List<MetricDto> selectAvailableCustomMetricsByComponentUuid(DbSession session, String projectUuid) {
        return MetricDao.mapper(session).selectAvailableCustomMetricsByComponentUuid(projectUuid);
    }

    public List<MetricDto> selectByIds(DbSession session, Set<Integer> idsSet) {
        return DatabaseUtils.executeLargeInputs(new ArrayList<Integer>(idsSet), MetricDao.mapper(session)::selectByIds);
    }

    private static MetricMapper mapper(DbSession session) {
        return (MetricMapper)session.getMapper(MetricMapper.class);
    }

    public void disableCustomByIds(DbSession session, List<Integer> ids) {
        DatabaseUtils.executeLargeInputsWithoutOutput(ids, input -> MetricDao.mapper(session).disableByIds((List<Integer>)input));
    }

    public boolean disableCustomByKey(DbSession session, String key) {
        return MetricDao.mapper(session).disableByKey(key) == 1;
    }

    public void update(DbSession session, MetricDto metric) {
        MetricDao.mapper(session).update(metric);
    }

    @CheckForNull
    public MetricDto selectById(DbSession session, long id) {
        return MetricDao.mapper(session).selectById(id);
    }

    private static class NotEmptyPredicate
    implements Predicate<String> {
        private NotEmptyPredicate() {
        }

        public boolean apply(@Nonnull String input) {
            return !input.isEmpty();
        }
    }
}

