/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.property;

import java.util.Optional;
import java.util.Set;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.property.InternalComponentPropertiesMapper;
import org.sonar.db.property.InternalComponentPropertyDto;

public class InternalComponentPropertiesDao
implements Dao {
    private final System2 system2;
    private final UuidFactory uuidFactory;

    public InternalComponentPropertiesDao(System2 system2, UuidFactory uuidFactory) {
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
    }

    private void insertOrUpdate(DbSession dbSession, InternalComponentPropertyDto dto) {
        InternalComponentPropertiesMapper mapper = InternalComponentPropertiesDao.getMapper(dbSession);
        dto.setUpdatedAt(this.system2.now());
        if (mapper.update(dto) == 1) {
            return;
        }
        dto.setUuid(this.uuidFactory.create());
        dto.setCreatedAt(this.system2.now());
        mapper.insert(dto);
    }

    public void insertOrUpdate(DbSession dbSession, String componentUuid, String key, String value) {
        this.insertOrUpdate(dbSession, new InternalComponentPropertyDto().setComponentUuid(componentUuid).setKey(key).setValue(value));
    }

    public void replaceValue(DbSession dbSession, String componentUuid, String key, String oldValue, String newValue) {
        InternalComponentPropertiesDao.getMapper(dbSession).replaceValue(componentUuid, key, oldValue, newValue, this.system2.now());
    }

    public Optional<InternalComponentPropertyDto> selectByComponentUuidAndKey(DbSession dbSession, String componentUuid, String key) {
        return InternalComponentPropertiesDao.getMapper(dbSession).selectByComponentUuidAndKey(componentUuid, key);
    }

    public int deleteByComponentUuid(DbSession dbSession, String componentUuid) {
        return InternalComponentPropertiesDao.getMapper(dbSession).deleteByComponentUuidAndKey(componentUuid);
    }

    public Set<String> selectDbKeys(DbSession dbSession, String key, String value) {
        return InternalComponentPropertiesDao.getMapper(dbSession).selectDbKeys(key, value);
    }

    private static InternalComponentPropertiesMapper getMapper(DbSession dbSession) {
        return (InternalComponentPropertiesMapper)dbSession.getMapper(InternalComponentPropertiesMapper.class);
    }
}

