/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.Dao;
import org.sonar.db.DbSession;
import org.sonar.db.property.InternalPropertiesMapper;
import org.sonar.db.property.InternalPropertyDto;

public class InternalPropertiesDao
implements Dao {
    private static final String LOCK_PREFIX = "lock.";
    static final int KEY_MAX_LENGTH = 20;
    private static final int TEXT_VALUE_MAX_LENGTH = 4000;
    private static final Optional<String> OPTIONAL_OF_EMPTY_STRING = Optional.of("");
    private final System2 system2;

    public InternalPropertiesDao(System2 system2) {
        this.system2 = system2;
    }

    public void save(DbSession dbSession, String key, String value) {
        InternalPropertiesDao.checkKey(key);
        Preconditions.checkArgument((value != null && !value.isEmpty() ? 1 : 0) != 0, (Object)"value can't be null nor empty");
        InternalPropertiesMapper mapper = InternalPropertiesDao.getMapper(dbSession);
        mapper.deleteByKey(key);
        long now = this.system2.now();
        if (InternalPropertiesDao.mustsBeStoredInClob(value)) {
            mapper.insertAsClob(key, value, now);
        } else {
            mapper.insertAsText(key, value, now);
        }
    }

    private static boolean mustsBeStoredInClob(String value) {
        return value.length() > 4000;
    }

    public void saveAsEmpty(DbSession dbSession, String key) {
        InternalPropertiesDao.checkKey(key);
        InternalPropertiesMapper mapper = InternalPropertiesDao.getMapper(dbSession);
        mapper.deleteByKey(key);
        mapper.insertAsEmpty(key, this.system2.now());
    }

    public void delete(DbSession dbSession, String key) {
        InternalPropertiesDao.getMapper(dbSession).deleteByKey(key);
    }

    public Map<String, Optional<String>> selectByKeys(DbSession dbSession, @Nullable Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        if (keys.size() == 1) {
            String key2 = keys.iterator().next();
            return ImmutableMap.of((Object)key2, this.selectByKey(dbSession, key2));
        }
        keys.forEach(InternalPropertiesDao::checkKey);
        InternalPropertiesMapper mapper = InternalPropertiesDao.getMapper(dbSession);
        List<InternalPropertyDto> res = mapper.selectAsText((List<String>)ImmutableList.copyOf(keys));
        HashMap builder = new HashMap(keys.size());
        res.forEach(internalPropertyDto -> {
            String key = internalPropertyDto.getKey();
            if (internalPropertyDto.isEmpty()) {
                builder.put(key, OPTIONAL_OF_EMPTY_STRING);
            }
            if (internalPropertyDto.getValue() != null) {
                builder.put(key, Optional.of(internalPropertyDto.getValue()));
            }
        });
        Sets.difference(keys, res.stream().map(InternalPropertyDto::getKey).collect(Collectors.toSet())).forEach(key -> builder.put(key, Optional.empty()));
        ImmutableList keyWithClobValue = ImmutableList.copyOf((Collection)Sets.difference(keys, builder.keySet()));
        if (keyWithClobValue.isEmpty()) {
            return ImmutableMap.copyOf(builder);
        }
        res = mapper.selectAsClob((List<String>)keyWithClobValue);
        res.forEach(internalPropertyDto -> builder.put(internalPropertyDto.getKey(), Optional.of(internalPropertyDto.getValue())));
        Sets.difference((Set)ImmutableSet.copyOf((Collection)keyWithClobValue), builder.keySet()).forEach(key -> builder.put(key, Optional.empty()));
        return ImmutableMap.copyOf(builder);
    }

    public Optional<String> selectByKey(DbSession dbSession, String key) {
        InternalPropertiesDao.checkKey(key);
        InternalPropertiesMapper mapper = InternalPropertiesDao.getMapper(dbSession);
        InternalPropertyDto res = InternalPropertiesDao.enforceSingleElement(key, mapper.selectAsText(Collections.singletonList(key)));
        if (res == null) {
            return Optional.empty();
        }
        if (res.isEmpty()) {
            return OPTIONAL_OF_EMPTY_STRING;
        }
        if (res.getValue() != null) {
            return Optional.of(res.getValue());
        }
        res = InternalPropertiesDao.enforceSingleElement(key, mapper.selectAsClob(Collections.singletonList(key)));
        if (res == null) {
            Loggers.get(InternalPropertiesDao.class).debug("Internal property {} has been found in db but has neither text value nor is empty. Still it couldn't be retrieved with clob value. Ignoring the property.", (Object)key);
            return Optional.empty();
        }
        return Optional.of(res.getValue());
    }

    @CheckForNull
    private static InternalPropertyDto enforceSingleElement(String key, List<InternalPropertyDto> rows) {
        if (rows.isEmpty()) {
            return null;
        }
        int size = rows.size();
        Preconditions.checkState((size <= 1 ? 1 : 0) != 0, (String)"%s rows retrieved for single property %s", (Object[])new Object[]{size, key});
        return rows.iterator().next();
    }

    public boolean tryLock(DbSession dbSession, String name, int maxAgeInSeconds) {
        String key = LOCK_PREFIX + name;
        if (key.length() > 20) {
            throw new IllegalArgumentException("lock name is too long");
        }
        long now = this.system2.now();
        Optional<String> timestampAsStringOpt = this.selectByKey(dbSession, key);
        if (!timestampAsStringOpt.isPresent()) {
            return this.tryCreateLock(dbSession, key, String.valueOf(now));
        }
        String oldTimestampString = timestampAsStringOpt.get();
        long oldTimestamp = Long.parseLong(oldTimestampString);
        if (oldTimestamp > now - (long)(maxAgeInSeconds * 1000)) {
            return false;
        }
        return InternalPropertiesDao.getMapper(dbSession).replaceValue(key, oldTimestampString, String.valueOf(now)) == 1;
    }

    private boolean tryCreateLock(DbSession dbSession, String name, String value) {
        try {
            InternalPropertiesDao.getMapper(dbSession).insertAsText(name, value, this.system2.now());
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static void checkKey(@Nullable String key) {
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"key can't be null nor empty");
    }

    private static InternalPropertiesMapper getMapper(DbSession dbSession) {
        return (InternalPropertiesMapper)dbSession.getMapper(InternalPropertiesMapper.class);
    }
}

