/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.property;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class PropertyDto {
    private static final int MAX_KEY_LENGTH = 512;
    private String key;
    private String value;
    private Long resourceId;
    private Integer userId;

    public String getKey() {
        return this.key;
    }

    public PropertyDto setKey(String key) {
        Preconditions.checkArgument((key.length() <= 512 ? 1 : 0) != 0, (String)"Setting key length (%s) is longer than the maximum authorized (%s). '%s' was provided", (Object[])new Object[]{key.length(), 512, key});
        this.key = key;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public PropertyDto setValue(@Nullable String value) {
        this.value = value;
        return this;
    }

    @CheckForNull
    public Long getResourceId() {
        return this.resourceId;
    }

    public PropertyDto setResourceId(@Nullable Long resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @CheckForNull
    public Integer getUserId() {
        return this.userId;
    }

    public PropertyDto setUserId(@Nullable Integer userId) {
        this.userId = userId;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDto other = (PropertyDto)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.userId, other.userId) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.resourceId, this.userId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.key).addValue((Object)this.value).addValue((Object)this.resourceId).addValue((Object)this.userId).toString();
    }
}

