/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.rule;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.SeverityUtil;

public class RuleForIndexingDto {
    private Integer id;
    private String repository;
    private String pluginRuleKey;
    private String name;
    private String description;
    private RuleDto.Format descriptionFormat;
    private Integer severity;
    private RuleStatus status;
    private boolean isTemplate;
    private String systemTags;
    private String securityStandards;
    private String templateRuleKey;
    private String templateRepository;
    private String internalKey;
    private String language;
    private boolean isExternal;
    private int type;
    private long createdAt;
    private long updatedAt;
    private static final Splitter TAGS_SPLITTER;
    private static final Splitter SECURITY_STANDARDS_SPLITTER;

    public Integer getId() {
        return this.id;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPluginRuleKey() {
        return this.pluginRuleKey;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleDto.Format getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public RuleStatus getStatus() {
        return this.status;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public String getSystemTags() {
        return this.systemTags;
    }

    public String getSecurityStandards() {
        return this.securityStandards;
    }

    public String getTemplateRuleKey() {
        return this.templateRuleKey;
    }

    public String getTemplateRepository() {
        return this.templateRepository;
    }

    public String getInternalKey() {
        return this.internalKey;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getType() {
        return this.type;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @CheckForNull
    public RuleType getTypeAsRuleType() {
        return RuleType.valueOfNullable((int)this.type);
    }

    public String getSeverityAsString() {
        return this.severity != null ? SeverityUtil.getSeverityFromOrdinal(this.severity) : null;
    }

    public RuleKey getRuleKey() {
        return RuleKey.of((String)this.repository, (String)this.pluginRuleKey);
    }

    public Set<String> getSystemTagsAsSet() {
        return ImmutableSet.copyOf((Iterable)TAGS_SPLITTER.split((CharSequence)(this.systemTags == null ? "" : this.systemTags)));
    }

    public Set<String> getSecurityStandardsAsSet() {
        return ImmutableSet.copyOf((Iterable)SECURITY_STANDARDS_SPLITTER.split((CharSequence)(this.securityStandards == null ? "" : this.securityStandards)));
    }

    static {
        SECURITY_STANDARDS_SPLITTER = TAGS_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    }
}

