/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.github;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.auth.github.GitHubSettings;
import org.sonarsource.auth.github.GsonEmails;
import org.sonarsource.auth.github.GsonTeams;
import org.sonarsource.auth.github.GsonUser;

@ServerSide
public class GitHubRestClient {
    private static final Logger LOGGER = Loggers.get(GitHubRestClient.class);
    private static final Pattern NEXT_LINK_PATTERN = Pattern.compile(".*<(.*)>; rel=\"next\"");
    private final GitHubSettings settings;

    public GitHubRestClient(GitHubSettings settings) {
        this.settings = settings;
    }

    GsonUser getUser(OAuth20Service scribe, OAuth2AccessToken accessToken) throws IOException, ExecutionException, InterruptedException {
        String responseBody = GitHubRestClient.executeRequest(this.settings.apiURL() + "user", scribe, accessToken).getBody();
        LOGGER.trace("User response received : {}", (Object)responseBody);
        return GsonUser.parse(responseBody);
    }

    String getEmail(OAuth20Service scribe, OAuth2AccessToken accessToken) throws IOException, ExecutionException, InterruptedException {
        String responseBody = GitHubRestClient.executeRequest(this.settings.apiURL() + "user/emails", scribe, accessToken).getBody();
        LOGGER.trace("Emails response received : {}", (Object)responseBody);
        List<GsonEmails.GsonEmail> emails = GsonEmails.parse(responseBody);
        return emails.stream().filter(email -> email.isPrimary() && email.isVerified()).findFirst().map(GsonEmails.GsonEmail::getEmail).orElse(null);
    }

    List<GsonTeams.GsonTeam> getTeams(OAuth20Service scribe, OAuth2AccessToken accessToken) throws IOException, ExecutionException, InterruptedException {
        Response response = GitHubRestClient.executeRequest(this.settings.apiURL() + "user/teams?per_page=100", scribe, accessToken);
        LOGGER.trace("Teams response received : {}", (Object)response.getBody());
        List<GsonTeams.GsonTeam> teams = GsonTeams.parse(response.getBody());
        GitHubRestClient.getNextTeams(teams, response, scribe, accessToken);
        return teams;
    }

    boolean isOrganizationMember(OAuth20Service scribe, OAuth2AccessToken accessToken, String organization, String login) throws IOException, ExecutionException, InterruptedException {
        String requestUrl = this.settings.apiURL() + String.format("orgs/%s/members/%s", organization, login);
        OAuthRequest request = new OAuthRequest(Verb.GET, requestUrl);
        scribe.signRequest(accessToken, request);
        Response response = scribe.execute(request);
        int code = response.getCode();
        switch (code) {
            case 204: 
            case 302: 
            case 404: {
                LOGGER.trace("Orgs response received : {}", (Object)code);
                return code == 204;
            }
        }
        throw GitHubRestClient.unexpectedResponseCode(requestUrl, response);
    }

    private static void getNextTeams(List<GsonTeams.GsonTeam> teams, Response response, OAuth20Service scribe, OAuth2AccessToken accessToken) throws InterruptedException, ExecutionException, IOException {
        String nextEndPoint = GitHubRestClient.readNextEndPoint(response);
        if (nextEndPoint == null) {
            return;
        }
        Response nextResponse = GitHubRestClient.executeRequest(nextEndPoint, scribe, accessToken);
        LOGGER.trace("Teams response received : {}", (Object)nextResponse.getBody());
        teams.addAll(GsonTeams.parse(nextResponse.getBody()));
        GitHubRestClient.getNextTeams(teams, nextResponse, scribe, accessToken);
    }

    private static Response executeRequest(String requestUrl, OAuth20Service scribe, OAuth2AccessToken accessToken) throws IOException, ExecutionException, InterruptedException {
        OAuthRequest request = new OAuthRequest(Verb.GET, requestUrl);
        scribe.signRequest(accessToken, request);
        Response response = scribe.execute(request);
        if (!response.isSuccessful()) {
            throw GitHubRestClient.unexpectedResponseCode(requestUrl, response);
        }
        return response;
    }

    @CheckForNull
    private static String readNextEndPoint(Response response) {
        String link = response.getHeader("Link");
        if (link == null || link.isEmpty() || !link.contains("rel=\"next\"")) {
            return null;
        }
        Matcher nextLinkMatcher = NEXT_LINK_PATTERN.matcher(link);
        if (!nextLinkMatcher.find()) {
            return null;
        }
        return nextLinkMatcher.group(1);
    }

    private static IllegalStateException unexpectedResponseCode(String requestUrl, Response response) throws IOException {
        return new IllegalStateException(String.format("Fail to execute request '%s'. HTTP code: %s, response: %s", requestUrl, response.getCode(), response.getBody()));
    }
}

