/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.repository.settings.ProjectSettingsLoader;
import org.sonar.scanner.scan.ProjectConfigurationProvider;
import org.sonar.scanner.scan.ProjectServerSettings;

public class ProjectServerSettingsProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(ProjectConfigurationProvider.class);
    private static final String MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING = "Settings that were previously configured at sub-project level are not used anymore. Transition the settings listed in \u2018General Settings -> General -> Archived Sub-Projects Settings' at project level, and clear the property to prevent the analysis from displaying this warning.";
    private ProjectServerSettings singleton = null;

    public ProjectServerSettings provide(ProjectSettingsLoader loader, AnalysisWarnings analysisWarnings) {
        if (this.singleton == null) {
            Map<String, String> serverSideSettings = loader.loadProjectSettings();
            if (StringUtils.isNotBlank(serverSideSettings.get("sonar.subproject.settings.archived"))) {
                LOG.warn(MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING);
                analysisWarnings.addUnique(MODULE_LEVEL_ARCHIVED_SETTINGS_WARNING);
            }
            this.singleton = new ProjectServerSettings(serverSideSettings);
        }
        return this.singleton;
    }
}

