/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.RawScannerProperties;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.scm.ScmConfiguration;
import org.sonar.scanner.scm.ScmRevision;

public class ScmRevisionImpl
implements ScmRevision {
    private static final Logger LOG = Loggers.get(ScmRevisionImpl.class);
    private final CiConfiguration ciConfiguration;
    private final RawScannerProperties scannerConfiguration;
    private final ScmConfiguration scmConfiguration;
    private final InputModuleHierarchy moduleHierarchy;

    public ScmRevisionImpl(CiConfiguration ciConfiguration, RawScannerProperties scannerConfiguration, ScmConfiguration scmConfiguration, InputModuleHierarchy moduleHierarchy) {
        this.ciConfiguration = ciConfiguration;
        this.scannerConfiguration = scannerConfiguration;
        this.scmConfiguration = scmConfiguration;
        this.moduleHierarchy = moduleHierarchy;
    }

    @Override
    public Optional<String> get() {
        Optional<String> revision = Optional.ofNullable(this.scannerConfiguration.property("sonar.scm.revision"));
        if (ScmRevisionImpl.isSet(revision)) {
            return revision;
        }
        revision = this.ciConfiguration.getScmRevision();
        if (ScmRevisionImpl.isSet(revision)) {
            return revision;
        }
        ScmProvider scmProvider = this.scmConfiguration.provider();
        if (scmProvider != null) {
            try {
                revision = Optional.ofNullable(scmProvider.revisionId(this.moduleHierarchy.root().getBaseDir()));
            }
            catch (UnsupportedOperationException e) {
                LOG.debug(e.getMessage());
                revision = Optional.empty();
            }
        }
        if (ScmRevisionImpl.isSet(revision)) {
            return revision;
        }
        return Optional.empty();
    }

    private static boolean isSet(Optional<String> opt) {
        return opt.isPresent() && !StringUtils.isBlank(opt.get());
    }
}

