/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public abstract class Artifact
implements Comparable<Artifact> {
    protected String key;
    protected SortedSet<Release> releases = new TreeSet<Release>();
    private Release devRelease;

    protected Artifact(String key) {
        this.key = key;
    }

    public final String getKey() {
        return this.key;
    }

    public final Artifact setKey(String key) {
        this.key = key;
        return this;
    }

    public final Release setDevRelease(Release release) {
        this.devRelease = release;
        return release;
    }

    public Release getDevRelease() {
        return this.devRelease;
    }

    public final Release addRelease(Release release) {
        this.releases.add(release);
        return release;
    }

    public final Release addRelease(Version version) {
        return this.addRelease(new Release(this, version));
    }

    public final Release addRelease(String version) {
        return this.addRelease(new Release(this, version));
    }

    public final Release getRelease(Version version) {
        for (Release release : this.getAllReleases()) {
            if (!release.getVersion().equals(version)) continue;
            return release;
        }
        throw new NoSuchElementException("Unable to find a release of plugin " + this.key + " with version " + version);
    }

    public boolean doesContainVersion(Version version) {
        for (Release release : this.getAllReleases()) {
            if (!release.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public Release getRelease(String versionOrAliases) {
        if ("DEV".equals(versionOrAliases)) {
            return this.getDevRelease();
        }
        if ("LATEST_RELEASE".equals(versionOrAliases)) {
            return this.getLastRelease();
        }
        return this.getRelease(Version.create(versionOrAliases));
    }

    public final SortedSet<Release> getReleases() {
        return this.releases;
    }

    public final SortedSet<Release> getReleasesGreaterThan(String version) {
        return this.getReleasesGreaterThan(Version.create(version));
    }

    public final SortedSet<Release> getReleasesGreaterThan(Version version) {
        TreeSet<Release> result = new TreeSet<Release>();
        for (Release release : this.getAllReleases()) {
            if (release.getVersion().compareToIgnoreQualifier(version) <= 0) continue;
            result.add(release);
        }
        return result;
    }

    public final SortedSet<Version> getVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Version> getPublicVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (!release.isPublic()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Release> getPublicReleases() {
        TreeSet<Release> publicReleases = new TreeSet<Release>();
        for (Release release : this.releases) {
            if (!release.isPublic()) continue;
            publicReleases.add(release);
        }
        return publicReleases;
    }

    public final SortedSet<Release> getArchivedReleases() {
        TreeSet<Release> archivedReleases = new TreeSet<Release>();
        for (Release release : this.releases) {
            if (!release.isArchived()) continue;
            archivedReleases.add(release);
        }
        return archivedReleases;
    }

    public final SortedSet<Version> getPrivateVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (release.isPublic() || release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Version> getArchivedVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (!release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    @CheckForNull
    public final Release getLastRelease() {
        return this.getAllReleases().isEmpty() ? null : this.getAllReleases().last();
    }

    @CheckForNull
    public final Release getLastCompatibleRelease(Version sqVersion) {
        Release result = null;
        for (Release r : this.getAllReleases()) {
            if (!r.supportSonarVersion(sqVersion)) continue;
            result = r;
        }
        return result;
    }

    @CheckForNull
    public final Release getLastCompatible(Version sonarVersion) {
        Release result = null;
        for (Release r : this.getAllReleases()) {
            if (!r.supportSonarVersion(sonarVersion)) continue;
            result = r;
        }
        return result;
    }

    @CheckForNull
    public final Release getFirstCompatible(Version sonarVersion) {
        for (Release r : this.getAllReleases()) {
            if (!r.supportSonarVersion(sonarVersion)) continue;
            return r;
        }
        return null;
    }

    @CheckForNull
    public final Release getMinimalRelease(Version minimalVersion) {
        for (Release r : this.getAllReleases()) {
            if (r.getVersion().compareToIgnoreQualifier(minimalVersion) < 0) continue;
            return r;
        }
        return null;
    }

    @CheckForNull
    public final Release getLastCompatibleReleaseIfUpgrade(Version sonarVersion) {
        Release result = null;
        for (Release r : this.getAllReleases()) {
            if (r.getLastRequiredSonarVersion() == null || r.getLastRequiredSonarVersion().compareToIgnoreQualifier(sonarVersion) < 0) continue;
            result = r;
        }
        return result;
    }

    public SortedSet<Release> getAllReleases() {
        TreeSet<Release> all = new TreeSet<Release>();
        all.addAll(this.getReleases());
        if (this.getDevRelease() != null) {
            all.add(this.getDevRelease());
        }
        return all;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return this.key.equals(artifact.key);
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public final int compareTo(Artifact other) {
        if (this.key == null) {
            return -1;
        }
        return this.key.compareTo(other.key);
    }
}

