/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.BooleanSupplier;
import org.sonar.application.StopRequestWatcher;

public abstract class AbstractStopRequestWatcher
extends Thread
implements StopRequestWatcher {
    private static final long DEFAULT_WATCHER_DELAY_MS = 500L;
    private final BooleanSupplier stopRequestedTest;
    private final Runnable stopAction;
    private final long delayMs;

    protected AbstractStopRequestWatcher(String threadName, BooleanSupplier stopRequestedTest, Runnable stopAction) {
        this(threadName, stopRequestedTest, stopAction, 500L);
    }

    @VisibleForTesting
    AbstractStopRequestWatcher(String threadName, BooleanSupplier stopRequestedTest, Runnable stopAction, long delayMs) {
        super(threadName);
        this.stopRequestedTest = stopRequestedTest;
        this.stopAction = stopAction;
        this.delayMs = delayMs;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.stopRequestedTest.getAsBoolean()) {
                    this.stopAction.run();
                    return;
                }
                Thread.sleep(this.delayMs);
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
            return;
        }
    }

    @VisibleForTesting
    long getDelayMs() {
        return this.delayMs;
    }

    @Override
    public void startWatching() {
        this.start();
    }

    @Override
    public void stopWatching() {
        this.interrupt();
    }
}

