/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.TreeMap;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.es.newindex.KeywordFieldBuilder;
import org.sonar.server.es.newindex.NestedFieldBuilder;
import org.sonar.server.es.newindex.TextFieldBuilder;

public abstract class FieldAware<U extends FieldAware<U>> {
    abstract U setFieldImpl(String var1, Object var2);

    protected final U setField(String fieldName, Object attributes) {
        Preconditions.checkArgument((!"indexType".equalsIgnoreCase(fieldName) ? 1 : 0) != 0, (String)"%s is a reserved field name", (Object[])new Object[]{"indexType"});
        return this.setFieldImpl(fieldName, attributes);
    }

    public KeywordFieldBuilder<U> keywordFieldBuilder(String fieldName) {
        return new KeywordFieldBuilder<FieldAware>(this, fieldName);
    }

    public TextFieldBuilder<U> textFieldBuilder(String fieldName) {
        return new TextFieldBuilder<FieldAware>(this, fieldName);
    }

    public NestedFieldBuilder<U> nestedFieldBuilder(String fieldName) {
        return new NestedFieldBuilder<FieldAware>(this, fieldName);
    }

    public U createBooleanField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"boolean"));
    }

    public U createByteField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"byte"));
    }

    public U createDateTimeField(String fieldName) {
        TreeMap<String, String> hash = new TreeMap<String, String>();
        hash.put("type", "date");
        hash.put("format", "date_time||epoch_second");
        return this.setField(fieldName, hash);
    }

    public U createDoubleField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"double"));
    }

    public U createIntegerField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"integer"));
    }

    public U createLongField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"long"));
    }

    public U createShortField(String fieldName) {
        return this.setField(fieldName, ImmutableMap.of((Object)"type", (Object)"short"));
    }

    public U createUuidPathField(String fieldName) {
        return this.setField(fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"text", (Comparable)((Object)"index"), (Object)"true", (Comparable)((Object)"analyzer"), (Object)DefaultIndexSettingsElement.UUID_MODULE_ANALYZER.getName()));
    }
}

