/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.newindex;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.TreeMap;
import org.sonar.server.es.newindex.FieldAware;

public class NestedFieldBuilder<U extends FieldAware<U>> {
    private final U parent;
    private final String fieldName;
    private final Map<String, Object> properties = new TreeMap<String, Object>();

    protected NestedFieldBuilder(U parent, String fieldName) {
        this.parent = parent;
        this.fieldName = fieldName;
    }

    private NestedFieldBuilder setProperty(String fieldName, Object value) {
        this.properties.put(fieldName, value);
        return this;
    }

    public NestedFieldBuilder addKeywordField(String fieldName) {
        return this.setProperty(fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"keyword", (Comparable)((Object)"index"), (Object)"true"));
    }

    public NestedFieldBuilder addDoubleField(String fieldName) {
        return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"double"));
    }

    public NestedFieldBuilder addIntegerField(String fieldName) {
        return this.setProperty(fieldName, ImmutableMap.of((Object)"type", (Object)"integer"));
    }

    public U build() {
        Preconditions.checkArgument((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"At least one sub-field must be declared in nested property '%s'", (Object[])new Object[]{this.fieldName});
        return ((FieldAware)this.parent).setField(this.fieldName, ImmutableSortedMap.of((Comparable)((Object)"type"), (Object)"nested", (Comparable)((Object)"properties"), this.properties));
    }
}

