/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification.email;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.user.User;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.user.DefaultUser;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.issue.notification.EmailMessage;
import org.sonar.server.issue.notification.EmailTemplate;

public class EmailNotificationChannel
extends NotificationChannel {
    private static final Logger LOG = Loggers.get(EmailNotificationChannel.class);
    private static final int SOCKET_TIMEOUT = 30000;
    private static final String LIST_ID_HEADER = "List-ID";
    private static final String LIST_ARCHIVE_HEADER = "List-Archive";
    private static final String IN_REPLY_TO_HEADER = "In-Reply-To";
    private static final String REFERENCES_HEADER = "References";
    private static final String SUBJECT_DEFAULT = "Notification";
    private static final String SMTP_HOST_NOT_CONFIGURED_DEBUG_MSG = "SMTP host was not configured - email will not be sent";
    private final EmailSettings configuration;
    private final EmailTemplate[] templates;
    private final DbClient dbClient;

    public EmailNotificationChannel(EmailSettings configuration, EmailTemplate[] templates, DbClient dbClient) {
        this.configuration = configuration;
        this.templates = templates;
        this.dbClient = dbClient;
    }

    public boolean isActivated() {
        return !StringUtils.isBlank((String)this.configuration.getSmtpHost());
    }

    public boolean deliver(Notification notification, String username) {
        if (!this.isActivated()) {
            LOG.debug(SMTP_HOST_NOT_CONFIGURED_DEBUG_MSG);
            return false;
        }
        User user = this.findByLogin(username);
        if (user == null || StringUtils.isBlank((String)user.email())) {
            LOG.debug("User does not exist or has no email: {}", (Object)username);
            return false;
        }
        EmailMessage emailMessage = this.format(notification);
        if (emailMessage != null) {
            emailMessage.setTo(user.email());
            return this.deliver(emailMessage);
        }
        return false;
    }

    public int deliverAll(Set<EmailDeliveryRequest> deliveries) {
        if (deliveries.isEmpty() || !this.isActivated()) {
            LOG.debug(SMTP_HOST_NOT_CONFIGURED_DEBUG_MSG);
            return 0;
        }
        return (int)deliveries.stream().filter(t -> !t.getRecipientEmail().trim().isEmpty()).map(t -> {
            EmailMessage emailMessage = this.format(t.getNotification());
            if (emailMessage != null) {
                emailMessage.setTo(t.getRecipientEmail());
                return this.deliver(emailMessage);
            }
            return false;
        }).filter(Boolean::booleanValue).count();
    }

    @CheckForNull
    private User findByLogin(String login) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto dto = this.dbClient.userDao().selectActiveUserByLogin(dbSession, login);
            DefaultUser defaultUser = dto != null ? dto.toUser() : null;
            return defaultUser;
        }
    }

    private EmailMessage format(Notification notification) {
        for (EmailTemplate template : this.templates) {
            EmailMessage email = template.format(notification);
            if (email == null) continue;
            return email;
        }
        LOG.warn("Email template not found for notification: {}", (Object)notification);
        return null;
    }

    boolean deliver(EmailMessage emailMessage) {
        if (!this.isActivated()) {
            LOG.debug(SMTP_HOST_NOT_CONFIGURED_DEBUG_MSG);
            return false;
        }
        try {
            this.send(emailMessage);
            return true;
        }
        catch (EmailException e) {
            LOG.error("Unable to send email", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(EmailMessage emailMessage) throws EmailException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        try {
            LOG.trace("Sending email: {}", (Object)emailMessage);
            String host = this.resolveHost();
            Email email = EmailNotificationChannel.createEmailWithMessage(emailMessage);
            this.setHeaders(email, emailMessage, host);
            this.setConnectionDetails(email);
            this.setToAndFrom(email, emailMessage);
            this.setSubject(email, emailMessage);
            email.send();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classloader);
        }
    }

    private static Email createEmailWithMessage(EmailMessage emailMessage) throws EmailException {
        if (emailMessage.isHtml()) {
            return new HtmlEmail().setHtmlMsg(emailMessage.getMessage());
        }
        return new SimpleEmail().setMsg(emailMessage.getMessage());
    }

    private void setSubject(Email email, EmailMessage emailMessage) {
        String subject = StringUtils.defaultIfBlank((String)(StringUtils.trimToEmpty((String)this.configuration.getPrefix()) + " "), (String)"") + StringUtils.defaultString((String)emailMessage.getSubject(), (String)SUBJECT_DEFAULT);
        email.setSubject(subject);
    }

    private void setToAndFrom(Email email, EmailMessage emailMessage) throws EmailException {
        String fromName = this.configuration.getFromName();
        String from = StringUtils.isBlank((String)emailMessage.getFrom()) ? fromName : emailMessage.getFrom() + " (" + fromName + ")";
        email.setFrom(this.configuration.getFrom(), from);
        email.addTo(emailMessage.getTo(), " ");
    }

    @CheckForNull
    private String resolveHost() {
        try {
            return new URL(this.configuration.getServerBaseURL()).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void setHeaders(Email email, EmailMessage emailMessage, @CheckForNull String host) {
        email.setCharset("UTF-8");
        if (StringUtils.isNotBlank((String)host)) {
            if (StringUtils.isNotEmpty((String)emailMessage.getMessageId())) {
                String messageId = "<" + emailMessage.getMessageId() + "@" + host + ">";
                email.addHeader(IN_REPLY_TO_HEADER, messageId);
                email.addHeader(REFERENCES_HEADER, messageId);
            }
            email.addHeader(LIST_ID_HEADER, "SonarQube <sonar." + host + ">");
            email.addHeader(LIST_ARCHIVE_HEADER, this.configuration.getServerBaseURL());
        }
    }

    private void setConnectionDetails(Email email) {
        email.setHostName(this.configuration.getSmtpHost());
        this.configureSecureConnection(email);
        if (StringUtils.isNotBlank((String)this.configuration.getSmtpUsername()) || StringUtils.isNotBlank((String)this.configuration.getSmtpPassword())) {
            email.setAuthentication(this.configuration.getSmtpUsername(), this.configuration.getSmtpPassword());
        }
        email.setSocketConnectionTimeout(30000);
        email.setSocketTimeout(30000);
    }

    private void configureSecureConnection(Email email) {
        if (StringUtils.equalsIgnoreCase((String)this.configuration.getSecureConnection(), (String)"ssl")) {
            email.setSSLOnConnect(true);
            email.setSSLCheckServerIdentity(true);
            email.setSslSmtpPort(String.valueOf(this.configuration.getSmtpPort()));
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else if (StringUtils.equalsIgnoreCase((String)this.configuration.getSecureConnection(), (String)"starttls")) {
            email.setStartTLSEnabled(true);
            email.setStartTLSRequired(true);
            email.setSSLCheckServerIdentity(true);
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else if (StringUtils.isBlank((String)this.configuration.getSecureConnection())) {
            email.setSmtpPort(this.configuration.getSmtpPort());
        } else {
            throw new SonarException("Unknown type of SMTP secure connection: " + this.configuration.getSecureConnection());
        }
    }

    public void sendTestEmail(String toAddress, String subject, String message) throws EmailException {
        try {
            EmailMessage emailMessage = new EmailMessage();
            emailMessage.setTo(toAddress);
            emailMessage.setSubject(subject);
            emailMessage.setPlainTextMessage(message);
            this.send(emailMessage);
        }
        catch (EmailException e) {
            LOG.debug("Fail to send test email to {}: {}", (Object)toAddress, (Object)e);
            throw e;
        }
    }

    @Immutable
    public static final class EmailDeliveryRequest {
        private final String recipientEmail;
        private final Notification notification;

        public EmailDeliveryRequest(String recipientEmail, Notification notification) {
            this.recipientEmail = Objects.requireNonNull(recipientEmail, "recipientEmail can't be null");
            this.notification = Objects.requireNonNull(notification, "notification can't be null");
        }

        public String getRecipientEmail() {
            return this.recipientEmail;
        }

        public Notification getNotification() {
            return this.notification;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EmailDeliveryRequest that = (EmailDeliveryRequest)o;
            return Objects.equals(this.recipientEmail, that.recipientEmail) && Objects.equals(this.notification, that.notification);
        }

        public int hashCode() {
            return Objects.hash(this.recipientEmail, this.notification);
        }

        public String toString() {
            return "EmailDeliveryRequest{'" + this.recipientEmail + '\'' + " : " + this.notification + '}';
        }
    }
}

