/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.es.IndexType;
import org.sonar.server.permission.index.IndexPermissions;

@Immutable
public final class AuthorizationScope {
    private final IndexType.IndexMainType indexType;
    private final Predicate<IndexPermissions> projectPredicate;

    public AuthorizationScope(IndexType.IndexRelationType functionalType, Predicate<IndexPermissions> projectPredicate) {
        this.indexType = AuthorizationScope.getAuthorizationIndexType(functionalType);
        this.projectPredicate = Objects.requireNonNull(projectPredicate);
    }

    private static IndexType.IndexMainType getAuthorizationIndexType(IndexType.IndexRelationType functionalType) {
        Objects.requireNonNull(functionalType);
        IndexType.IndexMainType mainType = functionalType.getMainType();
        Preconditions.checkArgument((boolean)"auth".equals(mainType.getType()), (String)"Index %s doesn't seem to be an authorized index as main type is not %s (got %s)", (Object[])new Object[]{mainType.getIndex(), "auth", mainType.getType()});
        return mainType;
    }

    public IndexType.IndexMainType getIndexType() {
        return this.indexType;
    }

    public Predicate<IndexPermissions> getProjectPredicate() {
        return this.projectPredicate;
    }
}

