/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;

@ComputeEngineSide
@ServerSide
public class UrlSettings {
    private static final String PROPERTY_CONTEXT = "sonar.web.context";
    private static final int DEFAULT_PORT = 9000;
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String ALL_IPS_HOST = "0.0.0.0";
    private final Configuration config;
    private final String contextPath;

    public UrlSettings(Configuration config) {
        this.config = config;
        this.contextPath = config.get(PROPERTY_CONTEXT).orElse("").replaceFirst("(\\/+)$", "");
    }

    public String getBaseUrl() {
        String url = this.config.get("sonar.core.serverBaseURL").orElse("");
        if (StringUtils.isEmpty((String)url)) {
            url = this.computeBaseUrl();
        }
        return StringUtils.removeEnd((String)url, (String)"/");
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isSecured() {
        return this.getBaseUrl().startsWith("https://");
    }

    private String computeBaseUrl() {
        String host = this.config.get("sonar.web.host").orElse("");
        int port = this.config.getInt("sonar.web.port").orElse(0);
        String context = this.config.get(PROPERTY_CONTEXT).orElse("");
        StringBuilder res = new StringBuilder();
        res.append("http://");
        UrlSettings.appendHost(host, res);
        UrlSettings.appendPort(port, res);
        UrlSettings.appendContext(context, res);
        return res.toString();
    }

    private static void appendHost(String host, StringBuilder res) {
        if (StringUtils.isEmpty((String)host) || ALL_IPS_HOST.equals(host)) {
            res.append("localhost");
        } else {
            res.append(host);
        }
    }

    private static void appendPort(int port, StringBuilder res) {
        if (port < 1) {
            res.append(':').append(9000);
        } else if (port != 80) {
            res.append(':').append(port);
        }
    }

    private static void appendContext(String context, StringBuilder res) {
        if (StringUtils.isNotEmpty((String)context)) {
            res.append(context);
        }
    }
}

