/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.ibatis.exceptions.PersistenceException;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.server.setting.NopSettingLoader;
import org.sonar.server.setting.SettingLoader;

@ComputeEngineSide
@ServerSide
public class ThreadLocalSettings
extends Settings {
    private static final Logger LOG = Loggers.get(ThreadLocalSettings.class);
    private final Properties overwrittenSystemProps = new Properties();
    private final Properties systemProps = new Properties();
    private static final ThreadLocal<Map<String, String>> CACHE = new ThreadLocal();
    private Map<String, String> getPropertyDbFailureCache = Collections.emptyMap();
    private Map<String, String> getPropertiesDbFailureCache = Collections.emptyMap();
    private SettingLoader settingLoader;

    public ThreadLocalSettings(PropertyDefinitions definitions, Properties props) {
        this(definitions, props, new NopSettingLoader());
    }

    @VisibleForTesting
    ThreadLocalSettings(PropertyDefinitions definitions, Properties props, SettingLoader settingLoader) {
        super(definitions, new Encryption(null));
        this.settingLoader = settingLoader;
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.systemProps.put(k, v == null ? null : v.toString().trim())));
        this.getEncryption().setPathToSecretKey(props.getProperty("sonar.secretKeyPath"));
    }

    @VisibleForTesting
    SettingLoader getSettingLoader() {
        return this.settingLoader;
    }

    protected void setSettingLoader(SettingLoader settingLoader) {
        this.settingLoader = Objects.requireNonNull(settingLoader);
    }

    protected Optional<String> get(String key) {
        String loadedValue;
        String value = this.overwrittenSystemProps.getProperty(key);
        if (value != null) {
            return Optional.of(value);
        }
        value = this.systemProps.getProperty(key);
        if (value != null) {
            return Optional.of(value);
        }
        Map<String, String> dbProps = CACHE.get();
        if (dbProps == null) {
            return Optional.ofNullable(this.load(key));
        }
        if (dbProps.containsKey(key)) {
            loadedValue = dbProps.get(key);
        } else {
            loadedValue = this.load(key);
            dbProps.put(key, loadedValue);
        }
        return Optional.ofNullable(loadedValue);
    }

    private String load(String key) {
        try {
            return this.settingLoader.load(key);
        }
        catch (PersistenceException e) {
            return this.getPropertyDbFailureCache.get(key);
        }
    }

    public void setSystemProperty(String key, String value) {
        ThreadLocalSettings.checkKeyAndValue(key, value);
        String systemValue = this.systemProps.getProperty(key);
        if (LOG.isDebugEnabled() && systemValue != null && !value.equals(systemValue)) {
            LOG.debug(String.format("System property '%s' with value '%s' overwritten with value '%s'", key, systemValue, value));
        }
        this.overwrittenSystemProps.put(key, value.trim());
    }

    protected void set(String key, String value) {
        ThreadLocalSettings.checkKeyAndValue(key, value);
        Map<String, String> dbProps = CACHE.get();
        if (dbProps != null) {
            dbProps.put(key, value.trim());
        }
    }

    private static void checkKeyAndValue(String key, String value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
    }

    protected void remove(String key) {
        Map<String, String> dbProps = CACHE.get();
        if (dbProps != null) {
            dbProps.remove(key);
        }
    }

    public void load() {
        CACHE.set(new HashMap());
    }

    public void unload() {
        Map<String, String> settings = CACHE.get();
        CACHE.remove();
        this.getPropertyDbFailureCache = settings;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.loadAll(result);
        this.systemProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.put((String)key, (String)value)));
        return Collections.unmodifiableMap(result);
    }

    private void loadAll(Map<String, String> appendTo) {
        try {
            Map<String, String> cache = this.settingLoader.loadAll();
            appendTo.putAll(cache);
            this.getPropertiesDbFailureCache = cache;
        }
        catch (PersistenceException e) {
            appendTo.putAll(this.getPropertiesDbFailureCache);
        }
    }
}

