/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.impl.Parser;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.cpd.PythonCpdAnalyzer;
import org.sonar.python.IssueLocation;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonConfiguration;
import org.sonar.python.PythonFile;
import org.sonar.python.PythonVisitorContext;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.metrics.FileMetrics;
import org.sonar.python.parser.PythonParser;

public class PythonScanner {
    private static final Logger LOG = Loggers.get(PythonScanner.class);
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12, 20, 30};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final SensorContext context;
    private final Parser<Grammar> parser;
    private final List<InputFile> inputFiles;
    private final Checks<PythonCheck> checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonCpdAnalyzer cpdAnalyzer;

    public PythonScanner(SensorContext context, Checks<PythonCheck> checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, List<InputFile> inputFiles) {
        this.context = context;
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.cpdAnalyzer = new PythonCpdAnalyzer(context);
        this.inputFiles = inputFiles;
        this.parser = PythonParser.create(new PythonConfiguration(context.fileSystem().encoding()));
    }

    public void scanFiles() {
        for (InputFile pythonFile : this.inputFiles) {
            if (this.context.isCancelled()) {
                return;
            }
            try {
                this.scanFile(pythonFile);
            }
            catch (Exception e) {
                LOG.warn("Unable to analyze file '{}'. Error: {}", (Object)pythonFile.toString(), (Object)e);
            }
        }
    }

    private void scanFile(InputFile inputFile) {
        PythonVisitorContext visitorContext;
        PythonFile pythonFile = SonarQubePythonFile.create(inputFile);
        try {
            visitorContext = new PythonVisitorContext(this.parser.parse(pythonFile.content()), pythonFile);
            this.saveMeasures(inputFile, visitorContext);
        }
        catch (RecognitionException e) {
            visitorContext = new PythonVisitorContext(pythonFile, e);
            LOG.error("Unable to parse file: " + inputFile.toString());
            LOG.error(e.getMessage());
            this.context.newAnalysisError().onFile(inputFile).at(inputFile.newPointer(e.getLine(), 0)).message(e.getMessage()).save();
        }
        for (PythonCheck check : this.checks.all()) {
            this.saveIssues(inputFile, check, check.scanFileForIssues(visitorContext));
        }
        new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
    }

    private void saveIssues(InputFile inputFile, PythonCheck check, List<PythonCheck.PreciseIssue> issues) {
        RuleKey ruleKey = this.checks.ruleKey((Object)check);
        for (PythonCheck.PreciseIssue preciseIssue : issues) {
            NewIssue newIssue = this.context.newIssue().forRule(ruleKey);
            Integer cost = preciseIssue.cost();
            if (cost != null) {
                newIssue.gap(Double.valueOf(cost.doubleValue()));
            }
            newIssue.at(PythonScanner.newLocation(inputFile, newIssue, preciseIssue.primaryLocation()));
            for (IssueLocation secondaryLocation : preciseIssue.secondaryLocations()) {
                newIssue.addLocation(PythonScanner.newLocation(inputFile, newIssue, secondaryLocation));
            }
            newIssue.save();
        }
    }

    private static NewIssueLocation newLocation(InputFile inputFile, NewIssue issue, IssueLocation location) {
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile);
        if (location.startLine() != 0) {
            TextRange range = location.startLineOffset() == -1 ? inputFile.selectLine(location.startLine()) : inputFile.newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
            newLocation.at(range);
        }
        if (location.message() != null) {
            newLocation.message(location.message());
        }
        return newLocation;
    }

    private void saveMeasures(InputFile inputFile, PythonVisitorContext visitorContext) {
        boolean ignoreHeaderComments = new PythonConfiguration(this.context.fileSystem().encoding()).getIgnoreHeaderComments();
        FileMetrics fileMetrics = new FileMetrics(visitorContext, ignoreHeaderComments);
        FileLinesVisitor fileLinesVisitor = fileMetrics.fileLinesVisitor();
        this.cpdAnalyzer.pushCpdTokens(inputFile, visitorContext);
        this.noSonarFilter.noSonarInFile(inputFile, fileLinesVisitor.getLinesWithNoSonar());
        Set<Integer> linesOfCode = fileLinesVisitor.getLinesOfCode();
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.NCLOC, linesOfCode.size());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, fileMetrics.numberOfStatements());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, fileMetrics.numberOfFunctions());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.CLASSES, fileMetrics.numberOfClasses());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, fileMetrics.complexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, fileMetrics.cognitiveComplexity());
        this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, fileLinesVisitor.getCommentLineCount());
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (int line : linesOfCode) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        for (int line : fileLinesVisitor.getExecutableLines()) {
            fileLinesContext.setIntValue("executable_lines_data", line, 1);
        }
        fileLinesContext.save();
    }

    private void saveMetricOnFile(InputFile inputFile, Metric<Integer> metric, Integer value) {
        this.context.newMeasure().withValue((Serializable)value).forMetric(metric).on((InputComponent)inputFile).save();
    }
}

