/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.csharp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractSonarWayProfile;

public class CSharpSonarWayProfile
extends AbstractSonarWayProfile {
    private static final Logger LOG = Loggers.get(CSharpSonarWayProfile.class);

    CSharpSonarWayProfile(@Nullable SonarRuntime sonarRuntime) {
        super(sonarRuntime, "cs", "csharp", "csharpsquid");
    }

    @Override
    protected void activateSecurityRules(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay) {
        String securityRepositoryKey = CSharpSonarWayProfile.getSecurityRepositoryKey();
        try {
            CSharpSonarWayProfile.getSecurityRuleKeys().forEach(key -> sonarWay.activateRule(securityRepositoryKey, key));
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.warn("Could not activate C# security rules", (Throwable)e);
        }
    }

    private static Set<String> getSecurityRuleKeys() {
        try {
            Class<?> csRulesClass = Class.forName("com.sonar.plugins.security.api.CsRules");
            Method getRuleKeysMethod = csRulesClass.getMethod("getRuleKeys", new Class[0]);
            return (Set)getRuleKeysMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            LOG.debug("com.sonar.plugins.security.api.CsRules#getRuleKeys is not found, no security rules added to Sonar way cs profile: " + e.getMessage());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.debug("[" + e.getClass().getName() + "] No security rules added to Sonar way cs profile: " + e.getMessage());
        }
        return new HashSet<String>();
    }

    private static String getSecurityRepositoryKey() {
        try {
            Class<?> csRulesClass = Class.forName("com.sonar.plugins.security.api.CsRules");
            Method getRuleKeysMethod = csRulesClass.getMethod("getRepositoryKey", new Class[0]);
            return (String)getRuleKeysMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.debug("com.sonar.plugins.security.api.CsRules#getRepositoryKey is not found, will use default repository key: " + e.getMessage());
            return "csharpsquid";
        }
    }
}

