/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine;

import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.sonar.commonruleengine.CognitiveComplexity;
import org.sonar.commonruleengine.Metrics;
import org.sonar.uast.UastNode;

public class MetricsVisitor {
    private Metrics metrics;

    public void enterFile(UastNode uast) {
        this.metrics = new Metrics();
        this.metrics.cognitiveComplexity = CognitiveComplexity.calculateFileComplexity(uast).value();
    }

    public void visitNode(UastNode node) {
        UastNode.Token token;
        if (node.is(UastNode.Kind.CLASS)) {
            ++this.metrics.numberOfClasses;
        }
        if (node.is(UastNode.Kind.FUNCTION)) {
            ++this.metrics.numberOfFunctions;
        }
        if (node.is(UastNode.Kind.STATEMENT)) {
            ++this.metrics.numberOfStatements;
        }
        if (node.is(UastNode.Kind.STATEMENT, UastNode.Kind.EXPRESSION, UastNode.Kind.CASE, UastNode.Kind.LABEL)) {
            MetricsVisitor.addLines(this.metrics.executableLines, node.firstToken());
        }
        if ((token = node.token) != null) {
            this.visitToken(node, token);
        }
    }

    private void visitToken(UastNode node, UastNode.Token token) {
        if (node.is(UastNode.Kind.EOF)) {
            return;
        }
        Set<Integer> lineNumbers = node.is(UastNode.Kind.COMMENT) ? this.metrics.commentLines : this.metrics.linesOfCode;
        MetricsVisitor.addLines(lineNumbers, token);
    }

    private static void addLines(Set<Integer> lineNumbers, @Nullable UastNode.Token token) {
        if (token != null) {
            IntStream.range(token.line, token.endLine + 1).forEach(lineNumbers::add);
        }
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

