/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.IfLike;

@Rule(key="S126")
public class IfElseIfWithoutElseCheck
extends Check {
    private Set<UastNode> visitedIf = new HashSet<UastNode>();

    public IfElseIfWithoutElseCheck() {
        super(UastNode.Kind.IF);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.visitedIf.clear();
        super.enterFile(inputFile);
    }

    @Override
    public void visitNode(UastNode node) {
        if (this.visitedIf.contains(node)) {
            return;
        }
        IfLike ifLike = IfLike.from(node);
        IfLike.ElseLike elseLike = ifLike.elseLike();
        if (elseLike == null) {
            return;
        }
        IfLike elseIf = elseLike.elseIf();
        while (elseIf != null && elseLike != null) {
            this.visitedIf.add(elseIf.node());
            elseLike = elseIf.elseLike();
            if (elseLike == null) continue;
            elseIf = elseLike.elseIf();
        }
        if (elseLike == null) {
            this.reportIssue(ifLike.ifKeyword(), "Add the missing else clause.");
        }
    }
}

