/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.AssignmentLike;
import org.sonar.uast.helpers.BinaryExpressionLike;

@Rule(key="S1314")
public class OctalNumberCheck
extends Check {
    private final Set<UastNode> bitwiseOperationArguments = new HashSet<UastNode>();

    public OctalNumberCheck() {
        super(UastNode.Kind.OCTAL_LITERAL, UastNode.Kind.BITWISE_AND, UastNode.Kind.BITWISE_AND_NOT, UastNode.Kind.BITWISE_OR, UastNode.Kind.BITWISE_XOR, UastNode.Kind.LEFT_SHIFT, UastNode.Kind.RIGHT_SHIFT, UastNode.Kind.LEFT_SHIFT_ASSIGNMENT, UastNode.Kind.RIGHT_SHIFT_ASSIGNMENT, UastNode.Kind.AND_ASSIGNMENT, UastNode.Kind.AND_NOT_ASSIGNMENT, UastNode.Kind.OR_ASSIGNMENT);
    }

    @Override
    public void enterFile(InputFile inputFile) throws IOException {
        this.bitwiseOperationArguments.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        if (node.is(UastNode.Kind.OCTAL_LITERAL)) {
            if (!OctalNumberCheck.isFilePermissionFormat(node) && !this.bitwiseOperationArguments.contains(node)) {
                this.reportIssue(node, "Use decimal rather than octal values.");
            }
        } else {
            BinaryExpressionLike binaryExpression = BinaryExpressionLike.from(node);
            if (binaryExpression != null) {
                this.bitwiseOperationArguments.add(binaryExpression.leftOperand());
                this.bitwiseOperationArguments.add(binaryExpression.rightOperand());
            } else {
                AssignmentLike assignmentLike = AssignmentLike.from(node);
                if (assignmentLike != null) {
                    assignmentLike.value().getDescendants(UastNode.Kind.ASSIGNMENT_VALUE, this.bitwiseOperationArguments::add);
                }
            }
        }
    }

    private static boolean isFilePermissionFormat(UastNode node) {
        String numberText;
        UastNode.Token token = node.firstToken();
        return token != null && (numberText = token.value).length() == 4;
    }
}

