/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.go.plugin.utils.PluginApiUtils;
import org.sonar.uast.UastNode;

public class CpdVisitor {
    private final InputFile inputFile;
    private final NewCpdTokens cpdTokens;

    CpdVisitor(SensorContext sensorContext, InputFile inputFile) {
        this.inputFile = inputFile;
        this.cpdTokens = sensorContext.newCpdTokens().onFile(inputFile);
    }

    public void scan(UastNode node) {
        if (node.is(UastNode.Kind.COMMENT, UastNode.Kind.EOF)) {
            return;
        }
        UastNode.Token token = node.token;
        if (token != null) {
            String text = token.value;
            if (node.is(UastNode.Kind.LITERAL)) {
                text = "LITERAL";
            }
            this.cpdTokens.addToken(PluginApiUtils.newRange(this.inputFile, token), text);
        }
        for (UastNode child : node.children) {
            this.scan(child);
        }
    }

    public void save() {
        this.cpdTokens.save();
    }
}

