/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.component;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;

public final class ComponentKeys {
    public static final int MAX_COMPONENT_KEY_LENGTH = 400;
    public static final String ALLOWED_CHARACTERS_MESSAGE = "Allowed characters are alphanumeric, '-', '_', '.' and ':', with at least one non-digit";
    public static final String MALFORMED_KEY_MESSAGE = "Malformed key for '%s'. %s.";
    private static final Pattern VALID_PROJECT_KEY_REGEXP = Pattern.compile("[\\p{Alnum}\\-_.:]*[\\p{Alpha}\\-_.:]+[\\p{Alnum}\\-_.:]*");
    private static final String VALID_BRANCH_REGEXP = "[\\p{Alnum}\\-_./]*";
    private static final String KEY_WITH_BRANCH_FORMAT = "%s:%s";

    private ComponentKeys() {
    }

    public static String createEffectiveKey(String projectKey, DefaultInputFile inputPath) {
        return ComponentKeys.createEffectiveKey(projectKey, inputPath.getProjectRelativePath());
    }

    public static String createEffectiveKey(String projectKey, @Nullable String path) {
        StringBuilder sb = new StringBuilder(400);
        sb.append(projectKey);
        if (path != null) {
            sb.append(':').append(path);
        }
        return sb.toString();
    }

    public static boolean isValidProjectKey(String keyCandidate) {
        return VALID_PROJECT_KEY_REGEXP.matcher(keyCandidate).matches();
    }

    public static void checkProjectKey(String keyCandidate) {
        Preconditions.checkArgument((boolean)ComponentKeys.isValidProjectKey(keyCandidate), (String)MALFORMED_KEY_MESSAGE, (Object[])new Object[]{keyCandidate, ALLOWED_CHARACTERS_MESSAGE});
    }

    public static boolean isValidLegacyBranch(String branchCandidate) {
        return branchCandidate.matches(VALID_BRANCH_REGEXP);
    }

    public static String createKey(String keyWithoutBranch, @Nullable String branch) {
        if (StringUtils.isNotBlank((String)branch)) {
            return String.format(KEY_WITH_BRANCH_FORMAT, keyWithoutBranch, branch);
        }
        return keyWithoutBranch;
    }

    public static String createKey(String projectKey, @Nullable String path, @Nullable String branch) {
        String key = ComponentKeys.createKey(projectKey, branch);
        return ComponentKeys.createEffectiveKey(key, path);
    }
}

