/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.sonar.api.internal.apachecommons.io.FileUtils;
import org.sonar.api.internal.apachecommons.io.IOUtils;

public final class ZipUtils {
    private static final String ERROR_CREATING_DIRECTORY = "Error creating directory: ";

    private ZipUtils() {
    }

    public static File unzip(File zip2, File toDir) throws IOException {
        return ZipUtils.unzip(zip2, toDir, (ZipEntry ze) -> true);
    }

    public static File unzip(InputStream zip2, File toDir) throws IOException {
        return ZipUtils.unzip(zip2, toDir, (ZipEntry ze) -> true);
    }

    @Deprecated
    public static File unzip(InputStream stream, File toDir, ZipEntryFilter filter) throws IOException {
        return ZipUtils.unzip(stream, toDir, (Predicate<ZipEntry>)new ZipEntryFilterDelegate(filter));
    }

    public static File unzip(InputStream stream, File toDir, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        Path targetDirNormalizedPath = toDir.toPath().normalize();
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!filter.test(entry)) continue;
                ZipUtils.unzipEntry(entry, zipStream, targetDirNormalizedPath);
            }
            File file = toDir;
            return file;
        }
    }

    private static void unzipEntry(ZipEntry entry, ZipInputStream zipStream, Path targetDirNormalized) throws IOException {
        File to = targetDirNormalized.resolve(entry.getName()).toFile();
        ZipUtils.verifyInsideTargetDirectory(entry, to.toPath(), targetDirNormalized);
        if (entry.isDirectory()) {
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(to);
        } else {
            File parent = to.getParentFile();
            ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
            ZipUtils.copy(zipStream, to);
        }
    }

    private static void throwExceptionIfDirectoryIsNotCreatable(File to) throws IOException {
        if (!to.exists() && !to.mkdirs()) {
            throw new IOException(ERROR_CREATING_DIRECTORY + to);
        }
    }

    @Deprecated
    public static File unzip(File zip2, File toDir, ZipEntryFilter filter) throws IOException {
        return ZipUtils.unzip(zip2, toDir, (Predicate<ZipEntry>)new ZipEntryFilterDelegate(filter));
    }

    public static File unzip(File zip2, File toDir, Predicate<ZipEntry> filter) throws IOException {
        if (!toDir.exists()) {
            FileUtils.forceMkdir(toDir);
        }
        Path targetDirNormalizedPath = toDir.toPath().normalize();
        try (ZipFile zipFile = new ZipFile(zip2);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!filter.test(entry)) continue;
                File target = new File(toDir, entry.getName());
                ZipUtils.verifyInsideTargetDirectory(entry, target.toPath(), targetDirNormalizedPath);
                if (entry.isDirectory()) {
                    ZipUtils.throwExceptionIfDirectoryIsNotCreatable(target);
                    continue;
                }
                File parent = target.getParentFile();
                ZipUtils.throwExceptionIfDirectoryIsNotCreatable(parent);
                ZipUtils.copy(zipFile, entry, target);
            }
            File file = toDir;
            return file;
        }
    }

    private static void copy(ZipInputStream zipStream, File to) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(to);){
            IOUtils.copy((InputStream)zipStream, (OutputStream)fos);
        }
    }

    private static void copy(ZipFile zipFile, ZipEntry entry, File to) throws IOException {
        try (InputStream input = zipFile.getInputStream(entry);
             FileOutputStream fos = new FileOutputStream(to);){
            IOUtils.copy(input, (OutputStream)fos);
        }
    }

    public static void zipDir(File dir, File zip2) throws IOException {
        try (OutputStream out = Files.newOutputStream(zip2.toPath(), new OpenOption[0]);
             ZipOutputStream zout = new ZipOutputStream(out);){
            ZipUtils.doZipDir(dir, zout);
        }
    }

    private static void doZip(String entryName, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    private static void doZip(String entryName, File file, ZipOutputStream out) throws IOException {
        if (file.isDirectory()) {
            entryName = entryName + "/";
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            File[] files = file.listFiles();
            if (files == null) {
                throw new IllegalStateException("Fail to list files of directory " + file.getAbsolutePath());
            }
            for (File f : files) {
                ZipUtils.doZip(entryName + f.getName(), f, out);
            }
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipUtils.doZip(entryName, in, out);
            }
        }
    }

    private static void doZipDir(File dir, ZipOutputStream out) throws IOException {
        File[] children = dir.listFiles();
        if (children == null) {
            throw new IllegalStateException("Fail to list files of directory " + dir.getAbsolutePath());
        }
        for (File child : children) {
            ZipUtils.doZip(child.getName(), child, out);
        }
    }

    private static void verifyInsideTargetDirectory(ZipEntry entry, Path entryPath, Path targetDirNormalizedPath) {
        if (!entryPath.normalize().startsWith(targetDirNormalizedPath)) {
            throw new IllegalStateException("Unzipping an entry outside the target directory is not allowed: " + entry.getName());
        }
    }

    private static class ZipEntryFilterDelegate
    implements Predicate<ZipEntry> {
        private final ZipEntryFilter delegate;

        private ZipEntryFilterDelegate(ZipEntryFilter delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(ZipEntry zipEntry) {
            return this.delegate.accept(zipEntry);
        }
    }

    @Deprecated
    @FunctionalInterface
    public static interface ZipEntryFilter {
        public boolean accept(ZipEntry var1);
    }
}

