/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.platform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentFactory;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.LifecycleStrategy;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.behaviors.OptInCaching;
import org.picocontainer.monitors.NullComponentMonitor;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.core.platform.ComponentKeys;
import org.sonar.core.platform.ContainerPopulator;
import org.sonar.core.platform.PicoUtils;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.StartableCloseableSafeLifecyleStrategy;

@ScannerSide
@ServerSide
@ComputeEngineSide
public class ComponentContainer
implements ContainerPopulator.Container {
    public static final int COMPONENTS_IN_EMPTY_COMPONENT_CONTAINER = 2;
    private ComponentContainer parent;
    private final List<ComponentContainer> children = new ArrayList<ComponentContainer>();
    private MutablePicoContainer pico;
    private PropertyDefinitions propertyDefinitions;
    private ComponentKeys componentKeys;

    public ComponentContainer() {
        this(ComponentContainer.createPicoContainer());
    }

    protected ComponentContainer(MutablePicoContainer picoContainer) {
        this(picoContainer, new PropertyDefinitions(System2.INSTANCE, new Object[0]));
    }

    protected ComponentContainer(MutablePicoContainer picoContainer, PropertyDefinitions propertyDefinitions) {
        Objects.requireNonNull(propertyDefinitions, "PropertyDefinitions can not be null");
        this.parent = null;
        this.pico = picoContainer;
        this.componentKeys = new ComponentKeys();
        this.propertyDefinitions = propertyDefinitions;
        this.addSingleton(propertyDefinitions);
        this.addSingleton(this);
    }

    protected ComponentContainer(ComponentContainer parent) {
        this.parent = parent;
        this.pico = parent.pico.makeChildContainer();
        this.parent.children.add(this);
        this.propertyDefinitions = parent.propertyDefinitions;
        this.componentKeys = new ComponentKeys();
        this.addSingleton(this);
    }

    protected void setParent(ComponentContainer parent) {
        this.parent = parent;
    }

    public void execute() {
        try {
            this.startComponents();
        }
        finally {
            this.stopComponents();
        }
    }

    public ComponentContainer startComponents() {
        try {
            this.doBeforeStart();
            this.pico.start();
            this.doAfterStart();
            return this;
        }
        catch (Exception e) {
            throw PicoUtils.propagate(e);
        }
    }

    protected void doBeforeStart() {
    }

    protected void doAfterStart() {
    }

    public ComponentContainer stopComponents() {
        try {
            this.stopChildren();
            if (this.pico.getLifecycleState().isStarted()) {
                this.pico.stop();
            }
            this.pico.dispose();
        }
        finally {
            if (this.parent != null) {
                this.parent.removeChild(this);
            }
        }
        return this;
    }

    private void stopChildren() {
        Lists.reverse(new ArrayList<ComponentContainer>(this.children)).forEach(ComponentContainer::stopComponents);
    }

    @Override
    public ComponentContainer add(Object ... objects) {
        for (Object object : objects) {
            if (object instanceof ComponentAdapter) {
                this.addPicoAdapter((ComponentAdapter)object);
                continue;
            }
            if (object instanceof Iterable) {
                this.add(Iterables.toArray((Iterable)object, Object.class));
                continue;
            }
            this.addSingleton(object);
        }
        return this;
    }

    public void addIfMissing(Object object, Class<?> objectType) {
        if (this.getComponentByType(objectType) == null) {
            this.add(object);
        }
    }

    @Override
    public ComponentContainer addSingletons(Iterable<?> components) {
        for (Object component : components) {
            this.addSingleton(component);
        }
        return this;
    }

    public ComponentContainer addSingleton(Object component) {
        return this.addComponent(component, true);
    }

    public ComponentContainer addComponent(Object component, boolean singleton) {
        Object key = this.componentKeys.of(component);
        if (component instanceof ComponentAdapter) {
            this.pico.addAdapter((ComponentAdapter)component);
        } else {
            try {
                this.pico.as(singleton ? Characteristics.CACHE : Characteristics.NO_CACHE).addComponent(key, component, new Parameter[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to register component " + ComponentContainer.getName(component), t);
            }
            this.declareExtension("", component);
        }
        return this;
    }

    public ComponentContainer addExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        Object key = this.componentKeys.of(extension);
        try {
            this.pico.as(Characteristics.CACHE).addComponent(key, extension, new Parameter[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to register extension " + ComponentContainer.getName(extension) + (pluginInfo != null ? " from plugin '" + pluginInfo.getKey() + "'" : ""), t);
        }
        this.declareExtension(pluginInfo, extension);
        return this;
    }

    public ComponentContainer addExtension(@Nullable String defaultCategory, Object extension) {
        Object key = this.componentKeys.of(extension);
        try {
            this.pico.as(Characteristics.CACHE).addComponent(key, extension, new Parameter[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Unable to register extension " + ComponentContainer.getName(extension), t);
        }
        this.declareExtension(defaultCategory, extension);
        return this;
    }

    private static String getName(Object extension) {
        if (extension instanceof Class) {
            return ((Class)extension).getName();
        }
        return ComponentContainer.getName(extension.getClass());
    }

    public void declareExtension(@Nullable PluginInfo pluginInfo, Object extension) {
        this.declareExtension(pluginInfo != null ? pluginInfo.getName() : "", extension);
    }

    public void declareExtension(@Nullable String defaultCategory, Object extension) {
        this.propertyDefinitions.addComponent(extension, Optional.ofNullable(defaultCategory).orElse(""));
    }

    public ComponentContainer addPicoAdapter(ComponentAdapter<?> adapter) {
        this.pico.addAdapter(adapter);
        return this;
    }

    @Override
    public <T> T getComponentByType(Class<T> type) {
        return this.pico.getComponent(type);
    }

    public Object getComponentByKey(Object key) {
        return this.pico.getComponent(key);
    }

    @Override
    public <T> List<T> getComponentsByType(Class<T> tClass) {
        return this.pico.getComponents(tClass);
    }

    public ComponentContainer removeChild(ComponentContainer childToBeRemoved) {
        Objects.requireNonNull(childToBeRemoved);
        Iterator<ComponentContainer> childrenIterator = this.children.iterator();
        while (childrenIterator.hasNext()) {
            ComponentContainer child = childrenIterator.next();
            if (child != childToBeRemoved) continue;
            if (!this.pico.removeChildContainer(child.pico)) break;
            childrenIterator.remove();
            break;
        }
        return this;
    }

    public ComponentContainer createChild() {
        return new ComponentContainer(this);
    }

    public static MutablePicoContainer createPicoContainer() {
        return new ExtendedDefaultPicoContainer(new OptInCaching(), new StartableCloseableSafeLifecyleStrategy(), null, new NullComponentMonitor());
    }

    public ComponentContainer getParent() {
        return this.parent;
    }

    public List<ComponentContainer> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public MutablePicoContainer getPicoContainer() {
        return this.pico;
    }

    public int size() {
        return this.pico.getComponentAdapters().size();
    }

    private static final class ExtendedDefaultPicoContainer
    extends DefaultPicoContainer {
        private ExtendedDefaultPicoContainer(ComponentFactory componentFactory, LifecycleStrategy lifecycleStrategy, @Nullable PicoContainer parent, ComponentMonitor componentMonitor) {
            super(componentFactory, lifecycleStrategy, parent, componentMonitor);
        }

        @Override
        public Object getComponent(Object componentKeyOrType, Class<? extends Annotation> annotation) {
            try {
                return super.getComponent(componentKeyOrType, annotation);
            }
            catch (Throwable t) {
                throw new IllegalStateException("Unable to load component " + componentKeyOrType, t);
            }
        }

        @Override
        public MutablePicoContainer makeChildContainer() {
            ExtendedDefaultPicoContainer pc = new ExtendedDefaultPicoContainer(this.componentFactory, this.lifecycleStrategy, this, this.componentMonitor);
            this.addChildContainer(pc);
            return pc;
        }
    }
}

