/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositoriesSupplier;
import org.sonar.scanner.scm.ScmChangedFiles;

@Immutable
public class StatusDetection {
    private final ProjectRepositoriesSupplier projectSettingsSupplier;
    private final ScmChangedFiles scmChangedFiles;

    public StatusDetection(ProjectRepositoriesSupplier projectSettingsSupplier, ScmChangedFiles scmChangedFiles) {
        this.projectSettingsSupplier = projectSettingsSupplier;
        this.scmChangedFiles = scmChangedFiles;
    }

    InputFile.Status status(String moduleKeyWithBranch, DefaultInputFile inputFile, String hash) {
        if (this.scmChangedFiles.isValid()) {
            return this.checkChangedWithScm(inputFile);
        }
        return this.checkChangedWithProjectRepositories(moduleKeyWithBranch, inputFile, hash);
    }

    private InputFile.Status checkChangedWithProjectRepositories(String moduleKeyWithBranch, DefaultInputFile inputFile, String hash) {
        FileData fileDataPerPath = this.projectSettingsSupplier.get().fileData(moduleKeyWithBranch, inputFile);
        if (fileDataPerPath == null) {
            return InputFile.Status.ADDED;
        }
        String previousHash = fileDataPerPath.hash();
        if (StringUtils.equals(hash, previousHash)) {
            return InputFile.Status.SAME;
        }
        if (StringUtils.isEmpty(previousHash)) {
            return InputFile.Status.ADDED;
        }
        return InputFile.Status.CHANGED;
    }

    private InputFile.Status checkChangedWithScm(DefaultInputFile inputFile) {
        if (!this.scmChangedFiles.isChanged(inputFile.path())) {
            return InputFile.Status.SAME;
        }
        return InputFile.Status.CHANGED;
    }
}

