/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.math.BigInteger;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.HasTextRange;
import org.sonarsource.slang.api.IntegerLiteralTree;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S1314")
public class OctalValuesCheck
implements SlangCheck {
    private static final String MESSAGE = "Use decimal values instead of octal ones.";
    private static final BigInteger EIGHT = BigInteger.valueOf(IntegerLiteralTree.Base.OCTAL.getRadix());
    private static final int FILE_PERMISSION_MASK_LENGTH = 3;

    @Override
    public void initialize(InitContext init) {
        init.register(IntegerLiteralTree.class, (ctx, literal) -> {
            if (literal.getBase() == IntegerLiteralTree.Base.OCTAL && !OctalValuesCheck.isException(literal)) {
                ctx.reportIssue((HasTextRange)literal, MESSAGE);
            }
        });
    }

    private static boolean isException(IntegerLiteralTree literalTree) {
        BigInteger value = literalTree.getIntegerValue();
        return value.compareTo(EIGHT) < 0 || literalTree.getNumericPart().length() == 3;
    }
}

