/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.plugin;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.ClassDeclarationTree;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.FunctionDeclarationTree;
import org.sonarsource.slang.api.ImportDeclarationTree;
import org.sonarsource.slang.api.PackageDeclarationTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.TopLevelTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.checks.complexity.CognitiveComplexity;
import org.sonarsource.slang.plugin.CyclomaticComplexityVisitor;
import org.sonarsource.slang.plugin.InputFileContext;
import org.sonarsource.slang.plugin.StatementsVisitor;
import org.sonarsource.slang.visitors.TreeVisitor;

public class MetricVisitor
extends TreeVisitor<InputFileContext> {
    public static final String NOSONAR_PREFIX = "NOSONAR";
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private Set<Integer> linesOfCode;
    private Set<Integer> commentLines;
    private Set<Integer> nosonarLines;
    private Set<Integer> executableLines;
    private int numberOfFunctions;
    private int numberOfClasses;
    private int complexity;
    private int statements;
    private int cognitiveComplexity;

    public MetricVisitor(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.register(TopLevelTree.class, (ctx, tree) -> {
            tree.allComments().forEach(comment -> MetricVisitor.addCommentMetrics(comment, this.commentLines, this.nosonarLines));
            this.addExecutableLines(tree.declarations());
            this.linesOfCode.addAll(tree.metaData().linesOfCode());
            this.complexity = new CyclomaticComplexityVisitor().complexityTrees((Tree)tree).size();
            this.statements = new StatementsVisitor().statements((Tree)tree);
            this.cognitiveComplexity = new CognitiveComplexity((Tree)tree).value();
        });
        this.register(FunctionDeclarationTree.class, (ctx, tree) -> {
            if (tree.name() != null && tree.body() != null) {
                ++this.numberOfFunctions;
            }
        });
        this.register(ClassDeclarationTree.class, (ctx, tree) -> ++this.numberOfClasses);
        this.register(BlockTree.class, (ctx, tree) -> this.addExecutableLines(tree.statementOrExpressions()));
    }

    private void addExecutableLines(List<Tree> trees) {
        trees.stream().filter(t -> !(t instanceof PackageDeclarationTree)).filter(t -> !(t instanceof ImportDeclarationTree)).filter(t -> !(t instanceof ClassDeclarationTree)).filter(t -> !(t instanceof FunctionDeclarationTree)).filter(t -> !(t instanceof BlockTree)).forEach(t -> this.executableLines.add(t.metaData().textRange().start().line()));
    }

    @Override
    protected void before(InputFileContext ctx, Tree root) {
        this.linesOfCode = new HashSet<Integer>();
        this.commentLines = new HashSet<Integer>();
        this.nosonarLines = new HashSet<Integer>();
        this.executableLines = new HashSet<Integer>();
        this.numberOfFunctions = 0;
        this.numberOfClasses = 0;
        this.complexity = 0;
        this.cognitiveComplexity = 0;
    }

    @Override
    protected void after(InputFileContext ctx, Tree root) {
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.NCLOC, this.linesOfCode().size());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COMMENT_LINES, this.commentLines().size());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.FUNCTIONS, this.numberOfFunctions());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.CLASSES, this.numberOfClasses());
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COMPLEXITY, this.complexity);
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.STATEMENTS, this.statements);
        MetricVisitor.saveMetric(ctx, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, this.cognitiveComplexity);
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(ctx.inputFile);
        this.linesOfCode().forEach(line -> fileLinesContext.setIntValue("ncloc_data", line.intValue(), 1));
        this.executableLines().forEach(line -> fileLinesContext.setIntValue("executable_lines_data", line.intValue(), 1));
        fileLinesContext.save();
        this.noSonarFilter.noSonarInFile(ctx.inputFile, this.nosonarLines());
    }

    private static void saveMetric(InputFileContext ctx, Metric<Integer> metric, Integer value) {
        ctx.sensorContext.newMeasure().on((InputComponent)ctx.inputFile).forMetric(metric).withValue((Serializable)value).save();
    }

    private static void addCommentMetrics(Comment comment, Set<Integer> commentLines, Set<Integer> nosonarLines) {
        MetricVisitor.add(comment.textRange(), commentLines);
        if (MetricVisitor.isNosonarComment(comment)) {
            MetricVisitor.add(comment.textRange(), nosonarLines);
        }
    }

    private static void add(TextRange range, Set<Integer> lineNumbers) {
        for (int i = range.start().line(); i <= range.end().line(); ++i) {
            lineNumbers.add(i);
        }
    }

    public static boolean isNosonarComment(Comment comment) {
        return comment.contentText().trim().toUpperCase(Locale.ENGLISH).startsWith(NOSONAR_PREFIX);
    }

    public Set<Integer> linesOfCode() {
        return this.linesOfCode;
    }

    public Set<Integer> commentLines() {
        return this.commentLines;
    }

    public Set<Integer> nosonarLines() {
        return this.nosonarLines;
    }

    public Set<Integer> executableLines() {
        return this.executableLines;
    }

    public int numberOfFunctions() {
        return this.numberOfFunctions;
    }

    public int numberOfClasses() {
        return this.numberOfClasses;
    }

    public int cognitiveComplexity() {
        return this.cognitiveComplexity;
    }
}

