/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.indices.InvalidIndexNameException;
import org.elasticsearch.indices.SystemIndices;

public class IndexNameExpressionResolver {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IndexNameExpressionResolver.class);
    public static final String EXCLUDED_DATA_STREAMS_KEY = "es.excluded_ds";
    public static final Version SYSTEM_INDEX_ENFORCEMENT_VERSION = Version.V_7_10_0;
    private final DateMathExpressionResolver dateMathExpressionResolver = new DateMathExpressionResolver();
    private final WildcardExpressionResolver wildcardExpressionResolver = new WildcardExpressionResolver();
    private final List<ExpressionResolver> expressionResolvers = org.elasticsearch.common.collect.List.of(this.dateMathExpressionResolver, this.wildcardExpressionResolver);
    private final ThreadContext threadContext;
    private final SystemIndices systemIndices;

    public IndexNameExpressionResolver(ThreadContext threadContext, SystemIndices systemIndices) {
        this.threadContext = Objects.requireNonNull(threadContext, "Thread Context must not be null");
        this.systemIndices = Objects.requireNonNull(systemIndices, "System Indices must not be null");
    }

    public String[] concreteIndexNames(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public String[] concreteIndexNamesWithSystemIndexAccess(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), name -> true);
        return this.concreteIndexNames(context, request.indices());
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request) {
        Context context = new Context(state, request.indicesOptions(), false, false, request.includeDataStreams(), this.getSystemIndexAccessPredicate());
        return this.concreteIndices(context, request.indices());
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, this.getSystemIndexAccessPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessPredicate());
        return this.concreteIndexNames(context, indexExpressions);
    }

    public String[] concreteIndexNames(ClusterState state, IndicesOptions options, IndicesRequest request) {
        Context context = new Context(state, options, false, false, request.includeDataStreams(), this.getSystemIndexAccessPredicate());
        return this.concreteIndexNames(context, request.indices());
    }

    public String[] concreteIndexNamesWithSystemIndexAccess(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        Context context = new Context(state, options, name -> true);
        return this.concreteIndexNames(context, indexExpressions);
    }

    public List<String> dataStreamNames(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        List<String> dataStreams;
        Context context = new Context(state, options, false, false, true, true, this.getSystemIndexAccessPredicate());
        if (indexExpressions == null || indexExpressions.length == 0) {
            indexExpressions = new String[]{"*"};
        }
        return ((dataStreams = this.wildcardExpressionResolver.resolve(context, Arrays.asList(indexExpressions))) == null ? org.elasticsearch.common.collect.List.of() : dataStreams).stream().map(x -> (IndexAbstraction)state.metadata().getIndicesLookup().get(x)).filter(Objects::nonNull).filter(ia -> ia.getType() == IndexAbstraction.Type.DATA_STREAM).map(IndexAbstraction::getName).collect(Collectors.toList());
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, String ... indexExpressions) {
        return this.concreteIndices(state, options, false, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesOptions options, boolean includeDataStreams, String ... indexExpressions) {
        Context context = new Context(state, options, false, false, includeDataStreams, this.getSystemIndexAccessPredicate());
        return this.concreteIndices(context, indexExpressions);
    }

    public Index[] concreteIndices(ClusterState state, IndicesRequest request, long startTime) {
        Context context = new Context(state, request.indicesOptions(), startTime, false, false, request.includeDataStreams(), false, this.getSystemIndexAccessPredicate());
        return this.concreteIndices(context, request.indices());
    }

    String[] concreteIndexNames(Context context, String ... indexExpressions) {
        Index[] indexes = this.concreteIndices(context, indexExpressions);
        String[] names = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            names[i] = indexes[i].getName();
        }
        return names;
    }

    Index[] concreteIndices(Context context, String ... indexExpressions) {
        if (indexExpressions == null || indexExpressions.length == 0) {
            indexExpressions = new String[]{"_all"};
        }
        Metadata metadata = context.getState().metadata();
        IndicesOptions options = context.getOptions();
        boolean failNoIndices = indexExpressions.length == 1 ? !options.allowNoIndices() : !options.ignoreUnavailable();
        List<String> expressions = Arrays.asList(indexExpressions);
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            expressions = expressionResolver.resolve(context, expressions);
        }
        if (expressions.isEmpty()) {
            if (!options.allowNoIndices()) {
                IndexNotFoundException infe = indexExpressions.length == 1 ? (indexExpressions[0].equals("_all") ? new IndexNotFoundException("no indices exist", (String)null) : new IndexNotFoundException((String)null)) : new IndexNotFoundException((String)null);
                infe.setResources("index_expression", indexExpressions);
                throw infe;
            }
            return Index.EMPTY_ARRAY;
        }
        boolean excludedDataStreams = false;
        LinkedHashSet<Index> concreteIndices = new LinkedHashSet<Index>(expressions.size());
        for (String expression : expressions) {
            IndexMetadata writeIndex;
            IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(expression);
            if (indexAbstraction == null) {
                if (!failNoIndices) continue;
                IndexNotFoundException infe = expression.equals("_all") ? new IndexNotFoundException("no indices exist", expression) : new IndexNotFoundException(expression);
                infe.setResources("index_expression", expression);
                throw infe;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && context.getOptions().ignoreAliases()) {
                if (!failNoIndices) continue;
                throw IndexNameExpressionResolver.aliasesNotSupportedException(expression);
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM && !context.includeDataStreams()) {
                excludedDataStreams = true;
                continue;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && context.isResolveToWriteIndex()) {
                writeIndex = indexAbstraction.getWriteIndex();
                if (writeIndex == null) {
                    throw new IllegalArgumentException("no write index is defined for alias [" + indexAbstraction.getName() + "]. The write index may be explicitly disabled using is_write_index=false or the alias points to multiple indices without one being designated as a write index");
                }
                if (!IndexNameExpressionResolver.addIndex(writeIndex, context)) continue;
                concreteIndices.add(writeIndex.getIndex());
                continue;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM && context.isResolveToWriteIndex()) {
                writeIndex = indexAbstraction.getWriteIndex();
                if (!IndexNameExpressionResolver.addIndex(writeIndex, context)) continue;
                concreteIndices.add(writeIndex.getIndex());
                continue;
            }
            if (indexAbstraction.getIndices().size() > 1 && !options.allowAliasesToMultipleIndices()) {
                Object[] indexNames = new String[indexAbstraction.getIndices().size()];
                int i = 0;
                for (IndexMetadata indexMetadata : indexAbstraction.getIndices()) {
                    indexNames[i++] = indexMetadata.getIndex().getName();
                }
                throw new IllegalArgumentException(indexAbstraction.getType().getDisplayName() + " [" + expression + "] has more than one index associated with it " + Arrays.toString(indexNames) + ", can't execute a single index op");
            }
            for (IndexMetadata index : indexAbstraction.getIndices()) {
                if (!IndexNameExpressionResolver.shouldTrackConcreteIndex(context, options, index)) continue;
                concreteIndices.add(index.getIndex());
            }
        }
        if (!options.allowNoIndices() && concreteIndices.isEmpty()) {
            IndexNotFoundException infe = new IndexNotFoundException((String)null);
            infe.setResources("index_expression", indexExpressions);
            if (excludedDataStreams) {
                infe.addMetadata(EXCLUDED_DATA_STREAMS_KEY, "true");
            }
            throw infe;
        }
        this.checkSystemIndexAccess(context, metadata, concreteIndices, indexExpressions);
        return concreteIndices.toArray(Index.EMPTY_ARRAY);
    }

    private void checkSystemIndexAccess(Context context, Metadata metadata, Set<Index> concreteIndices, String[] originalPatterns) {
        Predicate<String> systemIndexAccessPredicate = context.getSystemIndexAccessPredicate().negate();
        List systemIndicesThatShouldNotBeAccessed = concreteIndices.stream().map(metadata::index).filter(IndexMetadata::isSystem).filter(idxMetadata -> systemIndexAccessPredicate.test(idxMetadata.getIndex().getName())).collect(Collectors.toList());
        if (systemIndicesThatShouldNotBeAccessed.isEmpty()) {
            return;
        }
        ArrayList<String> resolvedSystemIndices = new ArrayList<String>();
        HashSet<String> resolvedSystemDataStreams = new HashSet<String>();
        SortedMap<String, IndexAbstraction> indicesLookup = metadata.getIndicesLookup();
        for (IndexMetadata idxMetadata2 : systemIndicesThatShouldNotBeAccessed) {
            IndexAbstraction abstraction = (IndexAbstraction)indicesLookup.get(idxMetadata2.getIndex().getName());
            if (abstraction.getParentDataStream() != null) {
                resolvedSystemDataStreams.add(abstraction.getParentDataStream().getName());
                continue;
            }
            resolvedSystemIndices.add(idxMetadata2.getIndex().getName());
        }
        if (!resolvedSystemIndices.isEmpty()) {
            Collections.sort(resolvedSystemIndices);
            deprecationLogger.deprecate(DeprecationCategory.API, "open_system_index_access", "this request accesses system indices: {}, but in a future major version, direct access to system indices will be prevented by default", resolvedSystemIndices);
        }
        if (!resolvedSystemDataStreams.isEmpty()) {
            throw this.systemIndices.dataStreamAccessException(this.threadContext, resolvedSystemDataStreams);
        }
    }

    private static boolean shouldTrackConcreteIndex(Context context, IndicesOptions options, IndexMetadata index) {
        if (index.getState() == IndexMetadata.State.CLOSE) {
            if (options.forbidClosedIndices() && !options.ignoreUnavailable()) {
                throw new IndexClosedException(index.getIndex());
            }
            return !options.forbidClosedIndices() && IndexNameExpressionResolver.addIndex(index, context);
        }
        if (index.getState() == IndexMetadata.State.OPEN) {
            return IndexNameExpressionResolver.addIndex(index, context);
        }
        throw new IllegalStateException("index state [" + (Object)((Object)index.getState()) + "] not supported");
    }

    private static boolean addIndex(IndexMetadata metadata, Context context) {
        return !(context.options.ignoreThrottled() && metadata.getSettings().getAsBoolean("index.frozen", false) != false);
    }

    private static IllegalArgumentException aliasesNotSupportedException(String expression) {
        return new IllegalArgumentException("The provided expression [" + expression + "] matches an alias, specify the corresponding concrete indices instead.");
    }

    public Index concreteSingleIndex(ClusterState state, IndicesRequest request) {
        String indexExpression = CollectionUtils.isEmpty(request.indices()) ? null : request.indices()[0];
        Index[] indices = this.concreteIndices(state, request.indicesOptions(), indexExpression);
        if (indices.length != 1) {
            throw new IllegalArgumentException("unable to return a single index as the index and options provided got resolved to multiple indices");
        }
        return indices[0];
    }

    public Index concreteWriteIndex(ClusterState state, IndicesRequest request) {
        if (request.indices() == null || request.indices() != null && request.indices().length != 1) {
            throw new IllegalArgumentException("indices request must specify a single index expression");
        }
        return this.concreteWriteIndex(state, request.indicesOptions(), request.indices()[0], false, request.includeDataStreams());
    }

    public Index concreteWriteIndex(ClusterState state, IndicesOptions options, String index, boolean allowNoIndices, boolean includeDataStreams) {
        IndicesOptions combinedOptions = IndicesOptions.fromOptions(options.ignoreUnavailable(), allowNoIndices, options.expandWildcardsOpen(), options.expandWildcardsClosed(), options.expandWildcardsHidden(), options.allowAliasesToMultipleIndices(), options.forbidClosedIndices(), options.ignoreAliases(), options.ignoreThrottled());
        Context context = new Context(state, combinedOptions, false, true, includeDataStreams, this.getSystemIndexAccessPredicate());
        Index[] indices = this.concreteIndices(context, index);
        if (allowNoIndices && indices.length == 0) {
            return null;
        }
        if (indices.length != 1) {
            throw new IllegalArgumentException("The index expression [" + index + "] and options provided did not point to a single write-index");
        }
        return indices[0];
    }

    public boolean hasIndexAbstraction(String indexAbstraction, ClusterState state) {
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), false, false, true, this.getSystemIndexAccessPredicate());
        String resolvedAliasOrIndex = DateMathExpressionResolver.resolveExpression(indexAbstraction, context);
        return state.metadata().getIndicesLookup().containsKey(resolvedAliasOrIndex);
    }

    public String resolveDateMathExpression(String dateExpression) {
        return DateMathExpressionResolver.resolveExpression(dateExpression, new Context(null, null, this.getSystemIndexAccessPredicate()));
    }

    public String resolveDateMathExpression(String dateExpression, long time) {
        return DateMathExpressionResolver.resolveExpression(dateExpression, new Context(null, null, time, this.getSystemIndexAccessPredicate()));
    }

    public Set<String> resolveExpressions(ClusterState state, String ... expressions) {
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), true, false, true, this.getSystemIndexAccessPredicate());
        List<String> resolvedExpressions = Arrays.asList(expressions);
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            resolvedExpressions = expressionResolver.resolve(context, resolvedExpressions);
        }
        return Collections.unmodifiableSet(new HashSet<String>(resolvedExpressions));
    }

    public String[] filteringAliases(ClusterState state, String index, Set<String> resolvedExpressions) {
        return this.indexAliases(state, index, AliasMetadata::filteringRequired, false, resolvedExpressions);
    }

    boolean iterateIndexAliases(int indexAliasesSize, int resolvedExpressionsSize) {
        return indexAliasesSize <= resolvedExpressionsSize;
    }

    public String[] indexAliases(ClusterState state, String index, Predicate<AliasMetadata> requiredAlias, boolean skipIdentity, Set<String> resolvedExpressions) {
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return null;
        }
        IndexMetadata indexMetadata = state.metadata().getIndices().get(index);
        if (indexMetadata == null) {
            throw new IndexNotFoundException(index);
        }
        if (!skipIdentity && resolvedExpressions.contains(index)) {
            return null;
        }
        ImmutableOpenMap<String, AliasMetadata> indexAliases = indexMetadata.getAliases();
        AliasMetadata[] aliasCandidates = this.iterateIndexAliases(indexAliases.size(), resolvedExpressions.size()) ? (AliasMetadata[])StreamSupport.stream(Spliterators.spliteratorUnknownSize(indexAliases.values().iterator(), 0), false).map(cursor -> (AliasMetadata)cursor.value).filter(aliasMetadata -> resolvedExpressions.contains(aliasMetadata.alias())).toArray(AliasMetadata[]::new) : (AliasMetadata[])resolvedExpressions.stream().map(indexAliases::get).filter(Objects::nonNull).toArray(AliasMetadata[]::new);
        ArrayList<String> aliases = null;
        for (AliasMetadata aliasMetadata2 : aliasCandidates) {
            if (requiredAlias.test(aliasMetadata2)) {
                if (aliases == null) {
                    aliases = new ArrayList<String>();
                }
            } else {
                return null;
            }
            aliases.add(aliasMetadata2.alias());
        }
        if (aliases == null) {
            return null;
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    public Map<String, Set<String>> resolveSearchRouting(ClusterState state, @Nullable String routing, String ... expressions) {
        List<String> resolvedExpressions = expressions != null ? Arrays.asList(expressions) : Collections.emptyList();
        Context context = new Context(state, IndicesOptions.lenientExpandOpen(), false, false, true, this.getSystemIndexAccessPredicate());
        for (ExpressionResolver expressionResolver : this.expressionResolvers) {
            resolvedExpressions = expressionResolver.resolve(context, resolvedExpressions);
        }
        if (IndexNameExpressionResolver.isAllIndices(resolvedExpressions)) {
            return this.resolveSearchRoutingAllIndices(state.metadata(), routing);
        }
        HashMap<String, HashSet<String>> routings = null;
        HashSet<String> paramRouting = null;
        HashSet<String> norouting = new HashSet<String>();
        if (routing != null) {
            paramRouting = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
        }
        for (String expression : resolvedExpressions) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(expression);
            if (indexAbstraction != null && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                for (IndexMetadata index : indexAbstraction.getIndices()) {
                    HashSet<Object> r;
                    String concreteIndex = index.getIndex().getName();
                    AliasMetadata aliasMetadata = index.getAliases().get(indexAbstraction.getName());
                    if (norouting.contains(concreteIndex)) continue;
                    if (!aliasMetadata.searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = new HashMap();
                        }
                        if ((r = (HashSet<String>)routings.get(concreteIndex)) == null) {
                            r = new HashSet<String>();
                            routings.put(concreteIndex, r);
                        }
                        r.addAll(aliasMetadata.searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(concreteIndex);
                        continue;
                    }
                    if (norouting.contains(concreteIndex)) continue;
                    norouting.add(concreteIndex);
                    if (paramRouting != null) {
                        r = new HashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = new HashMap();
                        }
                        routings.put(concreteIndex, r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(concreteIndex);
                }
                continue;
            }
            if (norouting.contains(expression)) continue;
            norouting.add(expression);
            if (paramRouting != null) {
                HashSet<String> r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = new HashMap<String, HashSet<String>>();
                }
                routings.put(expression, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(expression);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    public Map<String, Set<String>> resolveSearchRoutingAllIndices(Metadata metadata, String routing) {
        if (routing != null) {
            String[] concreteIndices;
            HashSet<String> r = Sets.newHashSet(Strings.splitStringByCommaToArray(routing));
            HashMap<String, Set<String>> routings = new HashMap<String, Set<String>>();
            for (String index : concreteIndices = metadata.getConcreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public static boolean isAllIndices(Collection<String> aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.isEmpty() || IndexNameExpressionResolver.isExplicitAllPattern(aliasesOrIndices);
    }

    static boolean isExplicitAllPattern(Collection<String> aliasesOrIndices) {
        return aliasesOrIndices != null && aliasesOrIndices.size() == 1 && "_all".equals(aliasesOrIndices.iterator().next());
    }

    boolean isPatternMatchingAllIndices(Metadata metadata, String[] indicesOrAliases, String[] concreteIndices) {
        if (concreteIndices.length == metadata.getConcreteAllIndices().length && indicesOrAliases.length > 0) {
            if (indicesOrAliases[0].charAt(0) == '-') {
                return true;
            }
            for (String indexOrAlias : indicesOrAliases) {
                if (!Regex.isSimpleMatchPattern(indexOrAlias)) continue;
                return true;
            }
        }
        return false;
    }

    public SystemIndices.SystemIndexAccessLevel getSystemIndexAccessLevel() {
        return this.systemIndices.getSystemIndexAccessLevel(this.threadContext);
    }

    public Predicate<String> getSystemIndexAccessPredicate() {
        SystemIndices.SystemIndexAccessLevel systemIndexAccessLevel = this.getSystemIndexAccessLevel();
        Predicate<String> systemIndexAccessLevelPredicate = systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.NONE ? s -> false : (systemIndexAccessLevel == SystemIndices.SystemIndexAccessLevel.ALL ? s -> true : this.systemIndices.getProductSystemIndexNamePredicate(this.threadContext));
        return systemIndexAccessLevelPredicate;
    }

    public static final class DateMathExpressionResolver
    implements ExpressionResolver {
        private static final DateFormatter DEFAULT_DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
        private static final String EXPRESSION_LEFT_BOUND = "<";
        private static final String EXPRESSION_RIGHT_BOUND = ">";
        private static final char LEFT_BOUND = '{';
        private static final char RIGHT_BOUND = '}';
        private static final char ESCAPE_CHAR = '\\';
        private static final char TIME_ZONE_BOUND = '|';

        @Override
        public List<String> resolve(Context context, List<String> expressions) {
            ArrayList<String> result = new ArrayList<String>(expressions.size());
            for (String expression : expressions) {
                result.add(DateMathExpressionResolver.resolveExpression(expression, context));
            }
            return result;
        }

        static String resolveExpression(String expression, Context context) {
            if (!expression.startsWith(EXPRESSION_LEFT_BOUND) || !expression.endsWith(EXPRESSION_RIGHT_BOUND)) {
                return expression;
            }
            boolean escape = false;
            boolean inDateFormat = false;
            boolean inPlaceHolder = false;
            StringBuilder beforePlaceHolderSb = new StringBuilder();
            StringBuilder inPlaceHolderSb = new StringBuilder();
            char[] text = expression.toCharArray();
            boolean from = true;
            int length = text.length - 1;
            block8: for (int i = 1; i < length; ++i) {
                char c;
                boolean escapedChar = escape;
                if (escape) {
                    escape = false;
                }
                if ((c = text[i]) == '\\') {
                    if (escapedChar) {
                        beforePlaceHolderSb.append(c);
                        escape = false;
                        continue;
                    }
                    escape = true;
                    continue;
                }
                if (inPlaceHolder) {
                    switch (c) {
                        case '{': {
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (!inDateFormat) {
                                inDateFormat = true;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character in placeholder at position [{}]", new String(text, 1, length), i);
                        }
                        case '}': {
                            ZoneId timeZone;
                            DateFormatter dateFormatter;
                            String mathExpression;
                            if (inDateFormat && escapedChar) {
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            if (inDateFormat) {
                                inDateFormat = false;
                                inPlaceHolderSb.append(c);
                                break;
                            }
                            String inPlaceHolderString = inPlaceHolderSb.toString();
                            int dateTimeFormatLeftBoundIndex = inPlaceHolderString.indexOf(123);
                            if (dateTimeFormatLeftBoundIndex < 0) {
                                mathExpression = inPlaceHolderString;
                                dateFormatter = DEFAULT_DATE_FORMATTER;
                                timeZone = ZoneOffset.UTC;
                            } else {
                                String dateFormatterPattern;
                                if (inPlaceHolderString.lastIndexOf(125) != inPlaceHolderString.length() - 1) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing closing `}` for date math format", inPlaceHolderString);
                                }
                                if (dateTimeFormatLeftBoundIndex == inPlaceHolderString.length() - 2) {
                                    throw new ElasticsearchParseException("invalid dynamic name expression [{}]. missing date format", inPlaceHolderString);
                                }
                                mathExpression = inPlaceHolderString.substring(0, dateTimeFormatLeftBoundIndex);
                                String patternAndTZid = inPlaceHolderString.substring(dateTimeFormatLeftBoundIndex + 1, inPlaceHolderString.length() - 1);
                                int formatPatternTimeZoneSeparatorIndex = patternAndTZid.indexOf(124);
                                if (formatPatternTimeZoneSeparatorIndex != -1) {
                                    dateFormatterPattern = patternAndTZid.substring(0, formatPatternTimeZoneSeparatorIndex);
                                    timeZone = DateUtils.of(patternAndTZid.substring(formatPatternTimeZoneSeparatorIndex + 1));
                                } else {
                                    dateFormatterPattern = patternAndTZid;
                                    timeZone = ZoneOffset.UTC;
                                }
                                dateFormatter = DateFormatter.forPattern(dateFormatterPattern);
                            }
                            DateFormatter formatter = dateFormatter.withZone(timeZone);
                            DateMathParser dateMathParser = formatter.toDateMathParser();
                            Instant instant = dateMathParser.parse(mathExpression, context::getStartTime, false, timeZone);
                            String time = formatter.format(instant);
                            beforePlaceHolderSb.append(time);
                            inPlaceHolderSb = new StringBuilder();
                            inPlaceHolder = false;
                            break;
                        }
                        default: {
                            inPlaceHolderSb.append(c);
                            break;
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '{': {
                        if (escapedChar) {
                            beforePlaceHolderSb.append(c);
                            continue block8;
                        }
                        inPlaceHolder = true;
                        continue block8;
                    }
                    case '}': {
                        if (!escapedChar) {
                            throw new ElasticsearchParseException("invalid dynamic name expression [{}]. invalid character at position [{}]. `{` and `}` are reserved characters and should be escaped when used as part of the index name using `\\` (e.g. `\\{text\\}`)", new String(text, 1, length), i);
                        }
                    }
                    default: {
                        beforePlaceHolderSb.append(c);
                    }
                }
            }
            if (inPlaceHolder) {
                throw new ElasticsearchParseException("invalid dynamic name expression [{}]. date math placeholder is open ended", new String(text, 1, length));
            }
            if (beforePlaceHolderSb.length() == 0) {
                throw new ElasticsearchParseException("nothing captured", new Object[0]);
            }
            return beforePlaceHolderSb.toString();
        }
    }

    static final class WildcardExpressionResolver
    implements ExpressionResolver {
        WildcardExpressionResolver() {
        }

        @Override
        public List<String> resolve(Context context, List<String> expressions) {
            IndicesOptions options = context.getOptions();
            Metadata metadata = context.getState().metadata();
            if (!options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                return expressions;
            }
            if (this.isEmptyOrTrivialWildcard(expressions)) {
                List<String> resolvedExpressions = WildcardExpressionResolver.resolveEmptyOrTrivialWildcard(options, metadata).stream().filter(expression -> {
                    IndexAbstraction abstraction = (IndexAbstraction)metadata.getIndicesLookup().get(expression);
                    if (abstraction != null && abstraction.isSystem()) {
                        if (abstraction.getType() == IndexAbstraction.Type.DATA_STREAM || abstraction.getParentDataStream() != null) {
                            return context.systemIndexAccessPredicate.test(abstraction.getName());
                        }
                        return true;
                    }
                    return true;
                }).collect(Collectors.toList());
                if (context.includeDataStreams()) {
                    IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(options);
                    Map<String, IndexAbstraction> dataStreamsAbstractions = metadata.getIndicesLookup().entrySet().stream().filter(entry -> ((IndexAbstraction)entry.getValue()).getType() == IndexAbstraction.Type.DATA_STREAM).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    HashSet<String> resolvedIncludingDataStreams = new HashSet<String>(resolvedExpressions);
                    resolvedIncludingDataStreams.addAll(WildcardExpressionResolver.expand(context, excludeState, dataStreamsAbstractions, expressions.isEmpty() ? "_all" : expressions.get(0), options.expandWildcardsHidden()));
                    return new ArrayList<String>(resolvedIncludingDataStreams);
                }
                return resolvedExpressions;
            }
            Set<String> result = this.innerResolve(context, expressions, options, metadata);
            if (result == null) {
                return expressions;
            }
            if (result.isEmpty() && !options.allowNoIndices()) {
                IndexNotFoundException infe = new IndexNotFoundException((String)null);
                infe.setResources("index_or_alias", expressions.toArray(new String[0]));
                throw infe;
            }
            return new ArrayList<String>(result);
        }

        private Set<String> innerResolve(Context context, List<String> expressions, IndicesOptions options, Metadata metadata) {
            HashSet<String> result = null;
            boolean wildcardSeen = false;
            for (int i = 0; i < expressions.size(); ++i) {
                boolean add;
                String expression = expressions.get(i);
                if (Strings.isEmpty(expression)) {
                    throw WildcardExpressionResolver.indexNotFoundException(expression);
                }
                WildcardExpressionResolver.validateAliasOrIndex(expression);
                if (WildcardExpressionResolver.aliasOrIndexExists(context, options, metadata, expression)) {
                    if (result == null) continue;
                    result.add(expression);
                    continue;
                }
                if (expression.charAt(0) == '-' && wildcardSeen) {
                    add = false;
                    expression = expression.substring(1);
                } else {
                    add = true;
                }
                if (result == null) {
                    result = new HashSet<String>(expressions.subList(0, i));
                }
                if (!Regex.isSimpleMatchPattern(expression)) {
                    if (!options.ignoreUnavailable()) {
                        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(expression);
                        if (indexAbstraction == null) {
                            throw WildcardExpressionResolver.indexNotFoundException(expression);
                        }
                        if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && options.ignoreAliases()) {
                            throw IndexNameExpressionResolver.aliasesNotSupportedException(expression);
                        }
                        if (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM && !context.includeDataStreams()) {
                            throw WildcardExpressionResolver.indexNotFoundException(expression);
                        }
                    }
                    if (add) {
                        result.add(expression);
                        continue;
                    }
                    result.remove(expression);
                    continue;
                }
                IndexMetadata.State excludeState = WildcardExpressionResolver.excludeState(options);
                Map<String, IndexAbstraction> matches = WildcardExpressionResolver.matches(context, metadata, expression);
                Set<String> expand = WildcardExpressionResolver.expand(context, excludeState, matches, expression, options.expandWildcardsHidden());
                if (add) {
                    result.addAll(expand);
                } else {
                    result.removeAll(expand);
                }
                if (!options.allowNoIndices() && matches.isEmpty()) {
                    throw WildcardExpressionResolver.indexNotFoundException(expression);
                }
                if (!Regex.isSimpleMatchPattern(expression)) continue;
                wildcardSeen = true;
            }
            return result;
        }

        private static void validateAliasOrIndex(String expression) {
            if (expression.charAt(0) == '_') {
                throw new InvalidIndexNameException(expression, "must not start with '_'.");
            }
        }

        private static boolean aliasOrIndexExists(Context context, IndicesOptions options, Metadata metadata, String expression) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(expression);
            if (indexAbstraction == null) {
                return false;
            }
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS && options.ignoreAliases()) {
                return false;
            }
            return indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM || context.includeDataStreams();
        }

        private static IndexNotFoundException indexNotFoundException(String expression) {
            IndexNotFoundException infe = new IndexNotFoundException(expression);
            infe.setResources("index_or_alias", expression);
            return infe;
        }

        private static IndexMetadata.State excludeState(IndicesOptions options) {
            IndexMetadata.State excludeState;
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                excludeState = null;
            } else if (options.expandWildcardsOpen() && !options.expandWildcardsClosed()) {
                excludeState = IndexMetadata.State.CLOSE;
            } else if (options.expandWildcardsClosed() && !options.expandWildcardsOpen()) {
                excludeState = IndexMetadata.State.OPEN;
            } else {
                assert (false) : "this shouldn't get called if wildcards expand to none";
                excludeState = null;
            }
            return excludeState;
        }

        public static Map<String, IndexAbstraction> matches(Context context, Metadata metadata, String expression) {
            if (Regex.isMatchAllPattern(expression)) {
                return WildcardExpressionResolver.filterIndicesLookup(context, metadata.getIndicesLookup(), null, context.getOptions());
            }
            if (expression.indexOf("*") == expression.length() - 1) {
                return WildcardExpressionResolver.suffixWildcard(context, metadata, expression);
            }
            return WildcardExpressionResolver.otherWildcard(context, metadata, expression);
        }

        private static Map<String, IndexAbstraction> suffixWildcard(Context context, Metadata metadata, String expression) {
            assert (expression.length() >= 2) : "expression [" + expression + "] should have at least a length of 2";
            String fromPrefix = expression.substring(0, expression.length() - 1);
            char[] toPrefixCharArr = fromPrefix.toCharArray();
            int n = toPrefixCharArr.length - 1;
            toPrefixCharArr[n] = (char)(toPrefixCharArr[n] + '\u0001');
            String toPrefix = new String(toPrefixCharArr);
            SortedMap<String, IndexAbstraction> subMap = metadata.getIndicesLookup().subMap(fromPrefix, toPrefix);
            return WildcardExpressionResolver.filterIndicesLookup(context, subMap, null, context.getOptions());
        }

        private static Map<String, IndexAbstraction> otherWildcard(Context context, Metadata metadata, String expression) {
            String pattern = expression;
            return WildcardExpressionResolver.filterIndicesLookup(context, metadata.getIndicesLookup(), e -> Regex.simpleMatch(pattern, (String)e.getKey()), context.getOptions());
        }

        private static Map<String, IndexAbstraction> filterIndicesLookup(Context context, SortedMap<String, IndexAbstraction> indicesLookup, Predicate<? super Map.Entry<String, IndexAbstraction>> filter, IndicesOptions options) {
            boolean shouldConsumeStream = false;
            Stream<Object> stream = indicesLookup.entrySet().stream();
            if (options.ignoreAliases()) {
                shouldConsumeStream = true;
                stream = stream.filter(e -> ((IndexAbstraction)e.getValue()).getType() != IndexAbstraction.Type.ALIAS);
            }
            if (filter != null) {
                shouldConsumeStream = true;
                stream = stream.filter(filter);
            }
            if (!context.includeDataStreams()) {
                shouldConsumeStream = true;
                stream = stream.filter(e -> ((IndexAbstraction)e.getValue()).getType() != IndexAbstraction.Type.DATA_STREAM);
            }
            if (shouldConsumeStream) {
                return stream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return indicesLookup;
        }

        private static Set<String> expand(Context context, IndexMetadata.State excludeState, Map<String, IndexAbstraction> matches, String expression, boolean includeHidden) {
            HashSet<String> expand = new HashSet<String>();
            for (Map.Entry<String, IndexAbstraction> entry : matches.entrySet()) {
                String aliasOrIndexName = entry.getKey();
                IndexAbstraction indexAbstraction = entry.getValue();
                if (indexAbstraction.isSystem() && (indexAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM || indexAbstraction.getParentDataStream() != null) && !context.systemIndexAccessPredicate.test(indexAbstraction.getName()) || indexAbstraction.isHidden() && !includeHidden && !WildcardExpressionResolver.implicitHiddenMatch(aliasOrIndexName, expression)) continue;
                if (context.isPreserveAliases() && indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                    expand.add(aliasOrIndexName);
                    continue;
                }
                for (IndexMetadata meta : indexAbstraction.getIndices()) {
                    if (excludeState != null && meta.getState() == excludeState) continue;
                    expand.add(meta.getIndex().getName());
                }
                if (!context.isPreserveDataStreams() || indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
                expand.add(indexAbstraction.getName());
            }
            return expand;
        }

        private static boolean implicitHiddenMatch(String itemName, String expression) {
            return itemName.startsWith(".") && expression.startsWith(".") && Regex.isSimpleMatchPattern(expression);
        }

        private boolean isEmptyOrTrivialWildcard(List<String> expressions) {
            return expressions.isEmpty() || expressions.size() == 1 && ("_all".equals(expressions.get(0)) || Regex.isMatchAllPattern(expressions.get(0)));
        }

        private static List<String> resolveEmptyOrTrivialWildcard(IndicesOptions options, Metadata metadata) {
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return Arrays.asList(metadata.getConcreteAllIndices());
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsClosed()) {
                return Arrays.asList(metadata.getConcreteVisibleIndices());
            }
            if (options.expandWildcardsOpen() && options.expandWildcardsHidden()) {
                return Arrays.asList(metadata.getConcreteAllOpenIndices());
            }
            if (options.expandWildcardsOpen()) {
                return Arrays.asList(metadata.getConcreteVisibleOpenIndices());
            }
            if (options.expandWildcardsClosed() && options.expandWildcardsHidden()) {
                return Arrays.asList(metadata.getConcreteAllClosedIndices());
            }
            if (options.expandWildcardsClosed()) {
                return Arrays.asList(metadata.getConcreteVisibleClosedIndices());
            }
            return Collections.emptyList();
        }
    }

    public static class Context {
        private final ClusterState state;
        private final IndicesOptions options;
        private final long startTime;
        private final boolean preserveAliases;
        private final boolean resolveToWriteIndex;
        private final boolean includeDataStreams;
        private final boolean preserveDataStreams;
        private final Predicate<String> systemIndexAccessPredicate;

        Context(ClusterState state, IndicesOptions options, Predicate<String> systemIndexAccessPredicate) {
            this(state, options, System.currentTimeMillis(), systemIndexAccessPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, Predicate<String> systemIndexAccessPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, false, systemIndexAccessPredicate);
        }

        Context(ClusterState state, IndicesOptions options, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, Predicate<String> systemIndexAccessPredicate) {
            this(state, options, System.currentTimeMillis(), preserveAliases, resolveToWriteIndex, includeDataStreams, preserveDataStreams, systemIndexAccessPredicate);
        }

        Context(ClusterState state, IndicesOptions options, long startTime, Predicate<String> systemIndexAccessPredicate) {
            this(state, options, startTime, false, false, false, false, systemIndexAccessPredicate);
        }

        protected Context(ClusterState state, IndicesOptions options, long startTime, boolean preserveAliases, boolean resolveToWriteIndex, boolean includeDataStreams, boolean preserveDataStreams, Predicate<String> systemIndexAccessPredicate) {
            this.state = state;
            this.options = options;
            this.startTime = startTime;
            this.preserveAliases = preserveAliases;
            this.resolveToWriteIndex = resolveToWriteIndex;
            this.includeDataStreams = includeDataStreams;
            this.preserveDataStreams = preserveDataStreams;
            this.systemIndexAccessPredicate = systemIndexAccessPredicate;
        }

        public ClusterState getState() {
            return this.state;
        }

        public IndicesOptions getOptions() {
            return this.options;
        }

        public long getStartTime() {
            return this.startTime;
        }

        boolean isPreserveAliases() {
            return this.preserveAliases;
        }

        boolean isResolveToWriteIndex() {
            return this.resolveToWriteIndex;
        }

        public boolean includeDataStreams() {
            return this.includeDataStreams;
        }

        public boolean isPreserveDataStreams() {
            return this.preserveDataStreams;
        }

        public Predicate<String> getSystemIndexAccessPredicate() {
            return this.systemIndexAccessPredicate;
        }
    }

    private static interface ExpressionResolver {
        public List<String> resolve(Context var1, List<String> var2);
    }
}

