/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.PagedBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public interface BytesReference
extends Comparable<BytesReference>,
ToXContentFragment {
    public static BytesReference bytes(XContentBuilder xContentBuilder) {
        xContentBuilder.close();
        OutputStream stream = xContentBuilder.getOutputStream();
        if (stream instanceof ByteArrayOutputStream) {
            return new BytesArray(((ByteArrayOutputStream)stream).toByteArray());
        }
        return ((BytesStream)stream).bytes();
    }

    public static byte[] toBytes(BytesReference reference) {
        BytesRef bytesRef = reference.toBytesRef();
        if (bytesRef.offset == 0 && bytesRef.length == bytesRef.bytes.length) {
            return bytesRef.bytes;
        }
        return ArrayUtil.copyOfSubArray(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }

    public static ByteBuffer[] toByteBuffers(BytesReference reference) {
        BytesRefIterator byteRefIterator = reference.iterator();
        try {
            BytesRef r;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            while ((r = byteRefIterator.next()) != null) {
                buffers.add(ByteBuffer.wrap(r.bytes, r.offset, r.length));
            }
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        catch (IOException e) {
            throw new AssertionError("won't happen", e);
        }
    }

    public static BytesReference fromByteBuffers(ByteBuffer[] buffers) {
        int bufferCount = buffers.length;
        if (bufferCount == 0) {
            return BytesArray.EMPTY;
        }
        if (bufferCount == 1) {
            return BytesReference.fromByteBuffer(buffers[0]);
        }
        BytesReference[] references = new BytesReference[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            references[i] = BytesReference.fromByteBuffer(buffers[i]);
        }
        return CompositeBytesReference.of(references);
    }

    public static BytesReference fromByteBuffer(ByteBuffer buffer) {
        if (!1.$assertionsDisabled && !buffer.hasArray()) {
            throw new AssertionError();
        }
        return new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
    }

    public static BytesReference fromByteArray(ByteArray byteArray, int length) {
        if (length == 0) {
            return BytesArray.EMPTY;
        }
        if (byteArray.hasArray()) {
            return new BytesArray(byteArray.array(), 0, length);
        }
        return new PagedBytesReference(byteArray, 0, length);
    }

    public byte get(int var1);

    public int getInt(int var1);

    public int indexOf(byte var1, int var2);

    public int length();

    public BytesReference slice(int var1, int var2);

    public long ramBytesUsed();

    public StreamInput streamInput() throws IOException;

    public void writeTo(OutputStream var1) throws IOException;

    public String utf8ToString();

    public BytesRef toBytesRef();

    public BytesRefIterator iterator();

    default public boolean hasArray() {
        return false;
    }

    default public byte[] array() {
        throw new UnsupportedOperationException();
    }

    default public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

