/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.unit;

import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RatioValue;

public class RelativeByteSizeValue {
    public static final RelativeByteSizeValue ZERO = new RelativeByteSizeValue(ByteSizeValue.ZERO);
    private final ByteSizeValue absolute;
    private final RatioValue ratio;

    public RelativeByteSizeValue(ByteSizeValue absolute) {
        this.absolute = absolute;
        this.ratio = null;
    }

    public RelativeByteSizeValue(RatioValue ratio) {
        this.absolute = null;
        this.ratio = ratio;
    }

    public boolean isAbsolute() {
        return this.absolute != null;
    }

    public ByteSizeValue getAbsolute() {
        return this.absolute;
    }

    public RatioValue getRatio() {
        return this.ratio;
    }

    public ByteSizeValue calculateValue(ByteSizeValue total, ByteSizeValue maxHeadroom) {
        if (this.ratio != null) {
            long ratioBytes = (long)Math.ceil(this.ratio.getAsRatio() * (double)total.getBytes());
            if (maxHeadroom != null && maxHeadroom.getBytes() != -1L) {
                return ByteSizeValue.ofBytes(Math.max(ratioBytes, total.getBytes() - maxHeadroom.getBytes()));
            }
            return ByteSizeValue.ofBytes(ratioBytes);
        }
        return this.absolute;
    }

    public boolean isNonZeroSize() {
        if (this.ratio != null) {
            return this.ratio.getAsRatio() > 0.0;
        }
        return this.absolute.getBytes() > 0L;
    }

    public static RelativeByteSizeValue parseRelativeByteSizeValue(String value, String settingName) {
        try {
            RatioValue ratio = RatioValue.parseRatioValue(value);
            if (ratio.getAsPercent() != 0.0 || value.endsWith("%")) {
                return new RelativeByteSizeValue(ratio);
            }
            return new RelativeByteSizeValue(ByteSizeValue.ZERO);
        }
        catch (ElasticsearchParseException ratio) {
            try {
                return new RelativeByteSizeValue(ByteSizeValue.parseBytesSizeValue(value, settingName));
            }
            catch (NumberFormatException | ElasticsearchParseException e) {
                throw new ElasticsearchParseException("unable to parse [{}={}] as either percentage or bytes", (Throwable)e, settingName, value);
            }
        }
    }

    public String getStringRep() {
        if (this.ratio != null) {
            return this.ratio.toString();
        }
        return this.absolute.getStringRep();
    }
}

