/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.GeoShapeParser;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;

public class GeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static Mapper.TypeParser PARSER = (name, node, parserContext) -> {
        boolean ignoreMalformedByDefault = (Boolean)IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
        boolean coerceByDefault = (Boolean)COERCE_SETTING.get(parserContext.getSettings());
        FieldMapper.Builder builder = parserContext.indexVersionCreated().before(Version.V_6_6_0) || LegacyGeoShapeFieldMapper.containsDeprecatedParameter(node.keySet()) ? new LegacyGeoShapeFieldMapper.Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault) : new Builder(name, ignoreMalformedByDefault, coerceByDefault);
        builder.parse(name, parserContext, node);
        return builder;
    };
    private final Builder builder;
    private final GeoShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((GeoShapeFieldMapper)in).builder;
    }

    public GeoShapeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, GeoShapeIndexer indexer, AbstractGeometryFieldMapper.Parser<Geometry> parser, Builder builder) {
        super(simpleName, mappedFieldType, builder.ignoreMalformed.get(), builder.coerce.get(), builder.ignoreZValue.get(), builder.orientation.get(), multiFields, copyTo, parser);
        this.builder = builder;
        this.indexer = indexer;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.ignoreMalformed.getDefaultValue().value(), this.builder.coerce.getDefaultValue().value()).init(this);
    }

    @Override
    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (mergeWith instanceof LegacyGeoShapeFieldMapper) {
            String strategy = ((LegacyGeoShapeFieldMapper)mergeWith).strategy();
            throw new IllegalArgumentException("mapper [" + this.name() + "] of type [geo_shape] cannot change strategy from [BKD] to [" + strategy + "]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    @Override
    protected void index(ParseContext context, Geometry geometry) throws IOException {
        if (geometry == null) {
            return;
        }
        context.doc().addAll(this.indexer.indexShape(geometry));
        this.createFieldNamesField(context);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<ShapeBuilder.Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault, boolean coerceByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> GeoShapeFieldMapper.builder((FieldMapper)m).coerce.get(), coerceByDefault);
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue.setValue(new Explicit<Boolean>(ignoreZValue, true));
            return this;
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta);
        }

        @Override
        public GeoShapeFieldMapper build(ContentPath contentPath) {
            GeometryParser geometryParser = new GeometryParser(this.orientation.get().value().getAsBoolean(), this.coerce.get().value(), this.ignoreZValue.get().value());
            GeoShapeParser geoShapeParser = new GeoShapeParser(geometryParser);
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(contentPath), this.indexed.get(), this.orientation.get().value(), geoShapeParser, this.meta.get());
            return new GeoShapeFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), new GeoShapeIndexer(this.orientation.get().value().getAsBoolean(), this.buildFullName(contentPath)), geoShapeParser, this);
        }
    }

    public static class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType
    implements GeoShapeQueryable {
        public GeoShapeFieldType(String name, boolean indexed, ShapeBuilder.Orientation orientation, AbstractGeometryFieldMapper.Parser<Geometry> parser, Map<String, String> meta) {
            super(name, indexed, false, false, false, parser, orientation, meta);
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(Version.V_7_5_0)) {
                throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            LatLonGeometry[] luceneGeometries = GeoShapeUtils.toLuceneGeometry(fieldName, context, shape, relation);
            if (luceneGeometries.length == 0) {
                return new MatchNoDocsQuery();
            }
            return LatLonShape.newGeometryQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
        }
    }
}

