/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.script.ScriptCompiler;

public abstract class Mapper
implements ToXContentFragment,
Iterable<Mapper> {
    private final String simpleName;

    public Mapper(String simpleName) {
        Objects.requireNonNull(simpleName);
        this.simpleName = simpleName;
    }

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String name();

    public abstract String typeName();

    public abstract Mapper merge(Mapper var1);

    public abstract void validate(MappingLookup var1);

    public static interface TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, ParserContext var3) throws MapperParsingException;

        public static class ParserContext {
            private final Function<String, SimilarityProvider> similarityLookupService;
            private final Function<String, TypeParser> typeParsers;
            private final Function<String, RuntimeField.Parser> runtimeFieldParsers;
            private final Version indexVersionCreated;
            private final Supplier<SearchExecutionContext> searchExecutionContextSupplier;
            private final DateFormatter dateFormatter;
            private final ScriptCompiler scriptCompiler;
            private final IndexAnalyzers indexAnalyzers;
            private final IndexSettings indexSettings;
            private final BooleanSupplier idFieldDataEnabled;

            public ParserContext(Function<String, SimilarityProvider> similarityLookupService, Function<String, TypeParser> typeParsers, Function<String, RuntimeField.Parser> runtimeFieldParsers, Version indexVersionCreated, Supplier<SearchExecutionContext> searchExecutionContextSupplier, DateFormatter dateFormatter, ScriptCompiler scriptCompiler, IndexAnalyzers indexAnalyzers, IndexSettings indexSettings, BooleanSupplier idFieldDataEnabled) {
                this.similarityLookupService = similarityLookupService;
                this.typeParsers = typeParsers;
                this.runtimeFieldParsers = runtimeFieldParsers;
                this.indexVersionCreated = indexVersionCreated;
                this.searchExecutionContextSupplier = searchExecutionContextSupplier;
                this.dateFormatter = dateFormatter;
                this.scriptCompiler = scriptCompiler;
                this.indexAnalyzers = indexAnalyzers;
                this.indexSettings = indexSettings;
                this.idFieldDataEnabled = idFieldDataEnabled;
            }

            public IndexAnalyzers getIndexAnalyzers() {
                return this.indexAnalyzers;
            }

            public IndexSettings getIndexSettings() {
                return this.indexSettings;
            }

            public BooleanSupplier isIdFieldDataEnabled() {
                return this.idFieldDataEnabled;
            }

            public Settings getSettings() {
                return this.indexSettings.getSettings();
            }

            public SimilarityProvider getSimilarity(String name) {
                return this.similarityLookupService.apply(name);
            }

            public TypeParser typeParser(String type) {
                return this.typeParsers.apply(type);
            }

            public RuntimeField.Parser runtimeFieldParser(String type) {
                return this.runtimeFieldParsers.apply(type);
            }

            public Version indexVersionCreated() {
                return this.indexVersionCreated;
            }

            public Supplier<SearchExecutionContext> searchExecutionContext() {
                return this.searchExecutionContextSupplier;
            }

            public DateFormatter getDateFormatter() {
                return this.dateFormatter;
            }

            public boolean isWithinMultiField() {
                return false;
            }

            public boolean isFromDynamicTemplate() {
                return false;
            }

            protected Function<String, SimilarityProvider> similarityLookupService() {
                return this.similarityLookupService;
            }

            public ScriptCompiler scriptCompiler() {
                return this.scriptCompiler;
            }

            ParserContext createMultiFieldContext(ParserContext in) {
                return new MultiFieldParserContext(in);
            }

            ParserContext createDynamicTemplateFieldContext(ParserContext in) {
                return new DynamicTemplateParserContext(in);
            }

            private static class MultiFieldParserContext
            extends ParserContext {
                MultiFieldParserContext(ParserContext in) {
                    super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.searchExecutionContextSupplier, in.dateFormatter, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldDataEnabled);
                }

                @Override
                public boolean isWithinMultiField() {
                    return true;
                }
            }

            private static class DynamicTemplateParserContext
            extends ParserContext {
                DynamicTemplateParserContext(ParserContext in) {
                    super(in.similarityLookupService, in.typeParsers, in.runtimeFieldParsers, in.indexVersionCreated, in.searchExecutionContextSupplier, in.dateFormatter, in.scriptCompiler, in.indexAnalyzers, in.indexSettings, in.idFieldDataEnabled);
                }

                @Override
                public boolean isFromDynamicTemplate() {
                    return true;
                }
            }
        }
    }

    public static abstract class Builder {
        protected final String name;

        protected Builder(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public abstract Mapper build(ContentPath var1);
    }
}

