/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.PeerRecoveryNotFound;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.ReestablishRecoveryRequest;
import org.elasticsearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;

public class PeerRecoverySourceService
extends AbstractLifecycleComponent
implements IndexEventListener,
ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PeerRecoverySourceService.class);
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    @Inject
    public PeerRecoverySourceService(TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings) {
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.recoverySettings = recoverySettings;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", "generic", StartRecoveryRequest::new, new StartRecoveryTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/reestablish_recovery", "generic", ReestablishRecoveryRequest::new, new ReestablishRecoveryTransportRequestHandler());
    }

    @Override
    protected void doStart() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.canContainData(clusterService.getSettings())) {
            clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        ClusterService clusterService = this.indicesService.clusterService();
        if (DiscoveryNode.canContainData(clusterService.getSettings())) {
            this.ongoingRecoveries.awaitEmpty();
            this.indicesService.clusterService().removeListener(this);
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel(indexShard, "shard is closed");
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.ongoingRecoveries.cancelOnNodeLeft(removedNode);
            }
        }
    }

    private void recover(StartRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        ShardRouting routingEntry = shard.routingEntry();
        if (!routingEntry.primary() || !routingEntry.active()) {
            throw new DelayRecoveryException("source shard [" + routingEntry + "] is not an active primary");
        }
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            logger.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + request.targetNode() + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        logger.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        handler.recoverToTarget(ActionListener.runAfter(listener, () -> this.ongoingRecoveries.remove(shard, handler)));
    }

    private void reestablish(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        logger.trace("[{}][{}] reestablishing recovery {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.recoveryId());
        this.ongoingRecoveries.reestablishRecovery(request, shard, listener);
    }

    final int numberOfOngoingRecoveries() {
        return this.ongoingRecoveries.ongoingRecoveries.size();
    }

    final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();
        private final Map<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>> nodeToHandlers = new HashMap<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>>();
        @Nullable
        private List<ActionListener<Void>> emptyListeners;

        OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> handlers = shardContext.addNewRecovery(request, shard);
            RemoteRecoveryTargetHandler recoveryTargetHandler = handlers.v2();
            this.nodeToHandlers.computeIfAbsent(recoveryTargetHandler.targetNode(), k -> new HashSet()).add(recoveryTargetHandler);
            shard.recoveryStats().incCurrentAsSource();
            return handlers.v1();
        }

        synchronized void cancelOnNodeLeft(DiscoveryNode node) {
            Collection<RemoteRecoveryTargetHandler> handlers = this.nodeToHandlers.get(node);
            if (handlers != null) {
                for (RemoteRecoveryTargetHandler handler : handlers) {
                    handler.cancel();
                }
            }
        }

        synchronized void reestablishRecovery(ReestablishRecoveryRequest request, IndexShard shard, ActionListener<RecoveryResponse> listener) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.get(shard);
            if (shardContext == null) {
                throw new PeerRecoveryNotFound(request.recoveryId(), request.shardId(), request.targetAllocationId());
            }
            shardContext.reestablishRecovery(request, listener);
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + shard + "]";
            RemoteRecoveryTargetHandler removed = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (removed != null) : "Handler was not registered [" + handler + "]";
            if (removed != null) {
                shard.recoveryStats().decCurrentAsSource();
                removed.cancel();
                assert (((Collection)this.nodeToHandlers.getOrDefault(removed.targetNode(), Collections.emptySet())).contains(removed)) : "Remote recovery was not properly tracked [" + removed + "]";
                this.nodeToHandlers.computeIfPresent(removed.targetNode(), (k, handlersForNode) -> {
                    handlersForNode.remove(removed);
                    if (handlersForNode.isEmpty()) {
                        return null;
                    }
                    return handlersForNode;
                });
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
            }
            if (this.ongoingRecoveries.isEmpty() && this.emptyListeners != null) {
                List onEmptyListeners = this.emptyListeners;
                this.emptyListeners = null;
                ActionListener.onResponse(onEmptyListeners, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers.keySet()) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                ExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEmpty() {
            PlainActionFuture future;
            assert (PeerRecoverySourceService.this.lifecycle.stoppedOrClosed());
            OngoingRecoveries ongoingRecoveries = this;
            synchronized (ongoingRecoveries) {
                if (this.ongoingRecoveries.isEmpty()) {
                    return;
                }
                future = new PlainActionFuture();
                if (this.emptyListeners == null) {
                    this.emptyListeners = new ArrayList<ActionListener<Void>>();
                }
                this.emptyListeners.add(future);
            }
            FutureUtils.get(future);
        }

        private final class ShardRecoveryContext {
            final Map<RecoverySourceHandler, RemoteRecoveryTargetHandler> recoveryHandlers = new HashMap<RecoverySourceHandler, RemoteRecoveryTargetHandler>();

            private ShardRecoveryContext() {
            }

            synchronized Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (!existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    throw new DelayRecoveryException("recovery with same target already registered, waiting for previous recovery attempt to be cancelled or completed");
                }
                Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> handlers = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.put(handlers.v1(), handlers.v2());
                return handlers;
            }

            synchronized void reestablishRecovery(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
                RecoverySourceHandler handler = null;
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (existingHandler.getRequest().recoveryId() != request.recoveryId() || !existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    handler = existingHandler;
                    break;
                }
                if (handler == null) {
                    throw new ResourceNotFoundException("Cannot reestablish recovery, recovery id [" + request.recoveryId() + "] not found.", new Object[0]);
                }
                handler.addListener(listener);
            }

            private Tuple<RecoverySourceHandler, RemoteRecoveryTargetHandler> createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime((long)throttleTime));
                RecoverySourceHandler handler = new RecoverySourceHandler(shard, recoveryTarget, shard.getThreadPool(), request, Math.toIntExact(PeerRecoverySourceService.this.recoverySettings.getChunkSize().getBytes()), PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentFileChunks(), PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentOperations());
                return Tuple.tuple(handler, recoveryTarget);
            }
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
        public static final String REESTABLISH_RECOVERY = "internal:index/shard/recovery/reestablish_recovery";
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            PeerRecoverySourceService.this.recover(request, new ChannelActionListener(channel, "internal:index/shard/recovery/start_recovery", request));
        }
    }

    class ReestablishRecoveryTransportRequestHandler
    implements TransportRequestHandler<ReestablishRecoveryRequest> {
        ReestablishRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(ReestablishRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            PeerRecoverySourceService.this.reestablish(request, new ChannelActionListener(channel, "internal:index/shard/recovery/reestablish_recovery", request));
        }
    }
}

