/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutMappingAction.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in put mapping requests is deprecated. The parameter will be removed in the next major version.";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_mapping"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/{type}/_mapping"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.POST, "/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.PUT, "/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/_mappings"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/{type}/_mappings"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/{type}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/{type}"), new RestHandler.Route(RestRequest.Method.POST, "/_mappings/{type}"), new RestHandler.Route(RestRequest.Method.PUT, "/_mappings/{type}")));
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecate(DeprecationCategory.TYPES, "put_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        String type = request.param("type");
        putMappingRequest.type(includeTypeName ? type : "_doc");
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (!includeTypeName && (type != null || MapperService.isMappingSourceTyped("_doc", sourceAsMap))) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests, unless the include_type_name parameter is set to true.");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putMappingRequest.masterNodeTimeout()));
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

