/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class ScoreScript {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DynamicMap.class);
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.common.collect.Map.of("doc", value -> {
        deprecationLogger.deprecate(DeprecationCategory.SCRIPTING, "score-script_doc", "Accessing variable [doc] via [params.doc] from within an score-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_doc", value -> {
        deprecationLogger.deprecate(DeprecationCategory.SCRIPTING, "score-script__doc", "Accessing variable [doc] via [params._doc] from within an score-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, "_source", value -> ((SourceLookup)value).source());
    public static final String[] PARAMETERS = new String[]{"explanation"};
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    private DoubleSupplier scoreSupplier = () -> 0.0;
    private final int docBase;
    private int docId;
    private int shardId = -1;
    private String indexName = null;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("score", Factory.class);

    public ScoreScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        if (lookup == null) {
            assert (params == null);
            assert (leafContext == null);
            this.params = null;
            this.leafLookup = null;
            this.docBase = 0;
        } else {
            this.leafLookup = lookup.getLeafSearchLookup(leafContext);
            params = new HashMap<String, Object>(params);
            params.putAll(this.leafLookup.asMap());
            this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
            this.docBase = leafContext.docBase;
        }
    }

    public abstract double execute(ExplanationHolder var1);

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.docId = docid;
        this.leafLookup.setDocument(docid);
    }

    public void setScorer(Scorable scorer) {
        this.scoreSupplier = () -> {
            try {
                return scorer.score();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public double get_score() {
        return this.scoreSupplier.getAsDouble();
    }

    public int _getDocId() {
        return this.docId;
    }

    public int _getDocBaseId() {
        return this.docBase + this.docId;
    }

    public int _getShardId() {
        if (this.shardId > -1) {
            return this.shardId;
        }
        throw new IllegalArgumentException("shard id can not be looked up!");
    }

    public String _getIndex() {
        if (this.indexName != null) {
            return this.indexName;
        }
        throw new IllegalArgumentException("index name can not be looked up!");
    }

    public void _setShard(int shardId) {
        this.shardId = shardId;
    }

    public void _setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public boolean needs_score();

        public ScoreScript newInstance(LeafReaderContext var1) throws IOException;
    }

    public static class ExplanationHolder {
        private String description;

        public void set(String description) {
            this.description = description;
        }

        public Explanation get(double score, Explanation subQueryExplanation) {
            if (this.description == null) {
                return null;
            }
            if (subQueryExplanation != null) {
                return Explanation.match((Number)score, this.description, subQueryExplanation);
            }
            return Explanation.match((Number)score, this.description, new Explanation[0]);
        }
    }
}

