/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.DateRangeHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public final class DateHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(DateHistogramAggregatorFactory.class);
    private final DateHistogramAggregationSupplier aggregatorSupplier;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final LongBounds extendedBounds;
    private final LongBounds hardBounds;
    private final Rounding rounding;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.DATE, CoreValuesSourceType.NUMERIC), DateHistogramAggregator::build, true);
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.RANGE, DateRangeHistogramAggregator::new, true);
        builder.register(DateHistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.BOOLEAN, (name, factories, rounding, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig, context, parent, cardinality, metadata) -> {
            DEPRECATION_LOGGER.deprecate(DeprecationCategory.AGGREGATIONS, "date-histogram-boolean", "Running DateHistogram aggregations on [boolean] fields is deprecated", new Object[0]);
            return DateHistogramAggregator.build(name, factories, rounding, order, keyed, minDocCount, extendedBounds, hardBounds, valuesSourceConfig, context, parent, cardinality, metadata);
        }, true);
    }

    public DateHistogramAggregatorFactory(String name, ValuesSourceConfig config, BucketOrder order, boolean keyed, long minDocCount, Rounding rounding, LongBounds extendedBounds, LongBounds hardBounds, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, DateHistogramAggregationSupplier aggregationSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregationSupplier;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
        this.rounding = rounding;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.aggregatorSupplier.build(this.name, this.factories, this.rounding, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, this.context, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new DateHistogramAggregator(this.name, this.factories, this.rounding, null, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, this.context, parent, CardinalityUpperBound.NONE, metadata);
    }
}

