/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1319")
public class CollectionImplementationReferencedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEQUE = "Deque";
    private static final String LIST = "List";
    private static final String MAP = "Map";
    private static final String CONCURRENT_MAP = "ConcurrentMap";
    private static final String QUEUE = "Queue";
    private static final String SET = "Set";
    private static final String SORTED_MAP = "SortedMap";
    private static final String SORTED_SET = "SortedSet";
    private static final Map<String, String> MAPPING = MapBuilder.newMap().put("ArrayDeque", "Deque").put("ConcurrentLinkedDeque", "Deque").put("AbstractList", "List").put("AbstractSequentialList", "List").put("ArrayList", "List").put("CopyOnWriteArrayList", "List").put("LinkedList", "List").put("AbstractMap", "Map").put("EnumMap", "Map").put("HashMap", "Map").put("Hashtable", "Map").put("IdentityHashMap", "Map").put("LinkedHashMap", "Map").put("WeakHashMap", "Map").put("ConcurrentHashMap", "ConcurrentMap").put("ConcurrentSkipListMap", "ConcurrentMap").put("AbstractQueue", "Queue").put("ConcurrentLinkedQueue", "Queue").put("SynchronousQueue", "Queue").put("AbstractSet", "Set").put("CopyOnWriteArraySet", "Set").put("EnumSet", "Set").put("HashSet", "Set").put("LinkedHashSet", "Set").put("TreeMap", "SortedMap").put("TreeSet", "SortedSet").build();
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers())) {
            this.checkIfAllowed(tree.type(), "The type of the \"" + tree.simpleName() + "\" object ");
        }
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if (CollectionImplementationReferencedCheck.isPublic(tree.modifiers()) && Boolean.FALSE.equals(tree.isOverriding())) {
            this.checkIfAllowed(tree.returnType(), "The return type of this method ");
            for (VariableTree variableTree : tree.parameters()) {
                this.checkIfAllowed(variableTree.type(), "The type of the \"" + variableTree.simpleName() + "\" object ");
            }
        }
    }

    private void checkIfAllowed(@Nullable TypeTree tree, String messagePrefix) {
        if (tree == null) {
            return;
        }
        String collectionImplementation = CollectionImplementationReferencedCheck.getTypeIdentifier(tree);
        String collectionInterface = MAPPING.get(collectionImplementation);
        if (collectionInterface != null) {
            this.context.reportIssue(this, tree, messagePrefix + CollectionImplementationReferencedCheck.messageRemainder(collectionImplementation, collectionInterface));
        }
    }

    private static boolean isPublic(ModifiersTree modifiers) {
        return ModifiersUtils.hasModifier(modifiers, Modifier.PUBLIC);
    }

    @CheckForNull
    private static String getTypeIdentifier(Tree tree) {
        Tree actualTree = tree.is(Tree.Kind.PARAMETERIZED_TYPE) ? ((ParameterizedTypeTree)tree).type() : tree;
        return actualTree.is(Tree.Kind.IDENTIFIER) ? ((IdentifierTree)actualTree).name() : null;
    }

    private static String messageRemainder(String collectionImplementation, String collectionInterface) {
        return "should be an interface such as \"" + collectionInterface + "\" rather than the implementation \"" + collectionImplementation + "\".";
    }
}

