/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2094")
public class EmptyClassCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null && EmptyClassCheck.isNotExtending(classTree) && EmptyClassCheck.isEmpty(classTree)) {
            this.reportIssue(simpleName, "Remove this empty class, write its code or make it an \"interface\".");
        }
    }

    private static boolean isNotExtending(ClassTree tree) {
        return tree.superClass() == null && tree.superInterfaces().isEmpty();
    }

    private static boolean isEmpty(ClassTree tree) {
        return tree.modifiers().annotations().isEmpty() && tree.members().stream().allMatch(member -> member.is(Tree.Kind.EMPTY_STATEMENT));
    }
}

