/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S881")
public class IncrementDecrementInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatementTree tree) {
        this.scanSkippingIncrementOrDecrement(tree.expression());
    }

    @Override
    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        this.scan(lambdaExpressionTree.parameters());
        this.scanSkippingIncrementOrDecrement(lambdaExpressionTree.body());
    }

    private void scanSkippingIncrementOrDecrement(Tree expressionTree) {
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement(expressionTree)) {
            UnaryExpressionTree unaryExpressionTree = (UnaryExpressionTree)expressionTree;
            expressionTree = unaryExpressionTree.expression();
        }
        this.scan(expressionTree);
    }

    @Override
    public void visitUnaryExpression(UnaryExpressionTree tree) {
        super.visitUnaryExpression(tree);
        if (IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement(tree)) {
            this.context.reportIssue(this, tree, "Extract this increment or decrement operator into a dedicated statement.");
        }
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        ExpressionTree expression = tree.expression();
        if (expression == null || !IncrementDecrementInSubExpressionCheck.isIncrementOrDecrement(expression)) {
            this.scan(expression);
        }
    }

    private static boolean isIncrementOrDecrement(Tree tree) {
        return tree.is(Tree.Kind.PREFIX_INCREMENT) || tree.is(Tree.Kind.PREFIX_DECREMENT) || tree.is(Tree.Kind.POSTFIX_INCREMENT) || tree.is(Tree.Kind.POSTFIX_DECREMENT);
    }
}

