/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2110")
public class InvalidDateValuesCheck
extends AbstractMethodDetection {
    public static final String JAVA_UTIL_CALENDAR = "java.util.Calendar";
    public static final String JAVA_UTIL_DATE = "java.util.Date";
    public static final String JAVA_SQL_DATE = "java.sql.Date";
    private static final String[] GREGORIAN_PARAMETERS = new String[]{"year", "month", "dayOfMonth", "hourOfDay", "minute", "second"};
    private static final String[] DATE_GET_METHODS = new String[]{"getDate", "getMonth", "getHours", "getMinutes", "getSeconds"};
    private static final String[] DATE_SET_METHODS = new String[]{"setDate", "setMonth", "setHours", "setMinutes", "setSeconds"};
    private static final MethodMatchers DATE_METHODS_COMPARISON = MethodMatchers.or(MethodMatchers.create().ofTypes("java.util.Calendar").names("get").addParametersMatcher("int").build(), MethodMatchers.create().ofTypes("java.util.Date").names(DATE_GET_METHODS).addWithoutParametersMatcher().build(), MethodMatchers.create().ofTypes("java.sql.Date").names(DATE_GET_METHODS).addWithoutParametersMatcher().build());

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> kinds = new ArrayList<Tree.Kind>(super.nodesToVisit());
        kinds.add(Tree.Kind.EQUAL_TO);
        kinds.add(Tree.Kind.NOT_EQUAL_TO);
        return kinds;
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (tree.is(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO)) {
            BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
            String name = InvalidDateValuesCheck.getThresholdToCheck(binaryExpressionTree.leftOperand());
            ExpressionTree argToCheck = null;
            if (name == null) {
                name = InvalidDateValuesCheck.getThresholdToCheck(binaryExpressionTree.rightOperand());
                if (name != null) {
                    argToCheck = binaryExpressionTree.leftOperand();
                }
            } else {
                argToCheck = binaryExpressionTree.rightOperand();
            }
            if (argToCheck != null) {
                this.checkArgument(argToCheck, name, "\"{0}\" is not a valid value for \"{1}\".");
            }
        }
    }

    @CheckForNull
    private static String getThresholdToCheck(ExpressionTree tree) {
        MethodInvocationTree mit;
        if (tree.is(Tree.Kind.METHOD_INVOCATION) && DATE_METHODS_COMPARISON.matches(mit = (MethodInvocationTree)tree)) {
            String name = InvalidDateValuesCheck.getMethodName(mit);
            return InvalidDateValuesCheck.getName(mit, name);
        }
        return null;
    }

    @CheckForNull
    private static String getName(MethodInvocationTree mit, String name) {
        if ("get".equals(name)) {
            return InvalidDateValuesCheck.getReferencedCalendarName((ExpressionTree)mit.arguments().get(0));
        }
        return name;
    }

    @CheckForNull
    private static String getReferencedCalendarName(ExpressionTree argument) {
        Symbol reference = null;
        if (argument.is(Tree.Kind.MEMBER_SELECT)) {
            reference = ((MemberSelectExpressionTree)argument).identifier().symbol();
        } else if (argument.is(Tree.Kind.IDENTIFIER)) {
            reference = ((IdentifierTree)argument).symbol();
        }
        if (reference != null && reference.owner().type().is(JAVA_UTIL_CALENDAR) && Threshold.getThreshold(reference.name()) != null) {
            return reference.name();
        }
        return null;
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.or(MethodMatchers.create().ofTypes(JAVA_UTIL_DATE, JAVA_SQL_DATE).names(DATE_SET_METHODS).addParametersMatcher("int").build(), MethodMatchers.create().ofTypes(JAVA_UTIL_CALENDAR).names("set").addParametersMatcher("int", "int").build(), MethodMatchers.create().ofTypes("java.util.GregorianCalendar").constructor().withAnyParameters().build());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String name = InvalidDateValuesCheck.getMethodName(mit);
        Arguments arguments = mit.arguments();
        if ("set".equals(name)) {
            ExpressionTree arg0 = (ExpressionTree)arguments.get(0);
            ExpressionTree arg1 = (ExpressionTree)arguments.get(1);
            String referenceName = InvalidDateValuesCheck.getReferencedCalendarName(arg0);
            if (referenceName != null) {
                this.checkArgument(arg1, referenceName, "\"{0}\" is not a valid value for setting \"{1}\".");
            }
        } else if ("<init>".equals(mit.symbol().name())) {
            this.checkConstructorArguments(mit.arguments());
        } else {
            this.checkArgument((ExpressionTree)arguments.get(0), name, "\"{0}\" is not a valid value for \"{1}\" method.");
        }
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        this.checkConstructorArguments(newClassTree.arguments());
    }

    private void checkConstructorArguments(Arguments arguments) {
        int numberArgsToCheck = Math.min(arguments.size(), GREGORIAN_PARAMETERS.length);
        for (int i = 1; i < numberArgsToCheck; ++i) {
            this.checkArgument((ExpressionTree)arguments.get(i), GREGORIAN_PARAMETERS[i], "\"{0}\" is not a valid value for setting \"{1}\".");
        }
    }

    private void checkArgument(ExpressionTree arg, String name, String message) {
        int argValue;
        LiteralTree literal = null;
        int sign = 1;
        if (arg.is(Tree.Kind.INT_LITERAL)) {
            literal = (LiteralTree)arg;
        } else if (arg.is(Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS) && ((UnaryExpressionTree)arg).expression().is(Tree.Kind.INT_LITERAL)) {
            if (arg.is(Tree.Kind.UNARY_MINUS)) {
                sign = -1;
            }
            literal = (LiteralTree)((UnaryExpressionTree)arg).expression();
        }
        if (literal != null && ((argValue = Integer.parseInt(literal.value()) * sign) > Threshold.getThreshold(name) || argValue < 0)) {
            this.reportIssue(arg, MessageFormat.format(message, argValue, name));
        }
    }

    private static String getMethodName(MethodInvocationTree mit) {
        return ExpressionUtils.methodName(mit).name();
    }

    private static enum Threshold {
        MONTH(11, "setMonth", "getMonth", "MONTH", "month"),
        DATE(31, "setDate", "getDate", "DAY_OF_MONTH", "dayOfMonth"),
        HOURS(23, "setHours", "getHours", "HOUR_OF_DAY", "hourOfDay"),
        MINUTE(60, "setMinutes", "getMinutes", "MINUTE", "minute"),
        SECOND(61, "setSeconds", "getSeconds", "SECOND", "second");

        private static Map<String, Integer> thresholdByName;
        private final int edgeValue;
        private final String javaDateSetter;
        private final String javaDateGetter;
        private final String calendarConstant;
        private final String gregorianParam;

        private Threshold(int edgeValue, String javaDateSetter, String javaDateGetter, String calendarConstant, String gregorianParam) {
            this.edgeValue = edgeValue;
            this.javaDateSetter = javaDateSetter;
            this.javaDateGetter = javaDateGetter;
            this.calendarConstant = calendarConstant;
            this.gregorianParam = gregorianParam;
        }

        public static Integer getThreshold(String name) {
            return thresholdByName.get(name);
        }

        static {
            thresholdByName = new HashMap<String, Integer>();
            for (Threshold value : Threshold.values()) {
                thresholdByName.put(value.javaDateSetter, value.edgeValue);
                thresholdByName.put(value.javaDateGetter, value.edgeValue);
                thresholdByName.put(value.calendarConstant, value.edgeValue);
                thresholdByName.put(value.gregorianParam, value.edgeValue);
            }
        }
    }
}

