/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1697")
public class NullDereferenceInConditionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        ExpressionTree nonNullOperand;
        IdentifierTree identifierTree;
        if ((NullDereferenceInConditionalCheck.isAndWithNullComparison(tree) || NullDereferenceInConditionalCheck.isOrWithNullExclusion(tree)) && (identifierTree = NullDereferenceInConditionalCheck.getIdentifier(nonNullOperand = NullDereferenceInConditionalCheck.getNonNullOperand(tree.leftOperand()))) != null) {
            IdentifierVisitor visitor = new IdentifierVisitor(identifierTree);
            tree.rightOperand().accept(visitor);
            if (visitor.raiseIssue) {
                this.context.reportIssue(this, tree, "Either reverse the equality operator in the \"" + identifierTree.name() + "\" null test, or reverse the logical operator that follows it.");
            }
        }
        super.visitBinaryExpression(tree);
    }

    private static IdentifierTree getIdentifier(ExpressionTree tree) {
        ExpressionTree nonNullOperand = ExpressionUtils.skipParentheses(tree);
        if (nonNullOperand.is(Tree.Kind.IDENTIFIER)) {
            return (IdentifierTree)nonNullOperand;
        }
        return null;
    }

    private static boolean isAndWithNullComparison(BinaryExpressionTree tree) {
        return tree.is(Tree.Kind.CONDITIONAL_AND) && NullDereferenceInConditionalCheck.isEqualNullComparison(tree.leftOperand());
    }

    private static boolean isOrWithNullExclusion(BinaryExpressionTree tree) {
        return tree.is(Tree.Kind.CONDITIONAL_OR) && NullDereferenceInConditionalCheck.isNotEqualNullComparison(tree.leftOperand());
    }

    private static boolean isEqualNullComparison(ExpressionTree tree) {
        return NullDereferenceInConditionalCheck.isNullComparison(tree, Tree.Kind.EQUAL_TO);
    }

    private static boolean isNotEqualNullComparison(ExpressionTree tree) {
        return NullDereferenceInConditionalCheck.isNullComparison(tree, Tree.Kind.NOT_EQUAL_TO);
    }

    private static boolean isNullComparison(ExpressionTree expressionTree, Tree.Kind comparatorKind) {
        ExpressionTree tree = ExpressionUtils.skipParentheses(expressionTree);
        if (tree.is(comparatorKind)) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            return binary.leftOperand().is(Tree.Kind.NULL_LITERAL) || binary.rightOperand().is(Tree.Kind.NULL_LITERAL);
        }
        return false;
    }

    private static ExpressionTree getNonNullOperand(ExpressionTree expressionTree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)ExpressionUtils.skipParentheses(expressionTree);
        if (binaryExpressionTree.leftOperand().is(Tree.Kind.NULL_LITERAL)) {
            return binaryExpressionTree.rightOperand();
        }
        return binaryExpressionTree.leftOperand();
    }

    private static class IdentifierVisitor
    extends BaseTreeVisitor {
        private IdentifierTree identifierTree;
        boolean raiseIssue = false;

        IdentifierVisitor(IdentifierTree identifierTree) {
            this.identifierTree = identifierTree;
        }

        @Override
        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (tree.expression().is(Tree.Kind.IDENTIFIER) || tree.expression().is(Tree.Kind.MEMBER_SELECT)) {
                this.scan(tree.expression());
            }
        }

        @Override
        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.isIdentifierWithSameName(tree.variable())) {
                this.scan(tree.variable());
            }
            this.scan(tree.expression());
        }

        @Override
        public void visitBinaryExpression(BinaryExpressionTree tree) {
            boolean scanLeft = true;
            boolean scanRight = true;
            if (tree.is(Tree.Kind.EQUAL_TO) || tree.is(Tree.Kind.NOT_EQUAL_TO)) {
                scanLeft = !this.isIdentifierWithSameName(tree.leftOperand());
                boolean bl = scanRight = !this.isIdentifierWithSameName(tree.rightOperand());
            }
            if (scanLeft) {
                this.scan(tree.leftOperand());
            }
            if (scanRight) {
                this.scan(tree.rightOperand());
            }
        }

        @Override
        public void visitIdentifier(IdentifierTree tree) {
            this.raiseIssue |= this.equalsIdentName(tree);
        }

        private boolean equalsIdentName(IdentifierTree tree) {
            return this.identifierTree.name().equals(tree.name());
        }

        private boolean isIdentifierWithSameName(ExpressionTree tree) {
            return tree.is(Tree.Kind.IDENTIFIER) && this.equalsIdentName((IdentifierTree)tree);
        }
    }
}

