/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@DeprecatedRuleKey(ruleKey="S00112", repositoryKey="squid")
@Rule(key="S112")
public class RawExceptionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final List<String> RAW_EXCEPTIONS = Arrays.asList("java.lang.Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException");
    private JavaFileScannerContext context;
    private final Set<Type> exceptionsThrownByMethodInvocations = new HashSet<Type>();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan(context.getTree());
    }

    @Override
    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        if ((tree.is(Tree.Kind.CONSTRUCTOR) || RawExceptionCheck.isNotOverridden(tree)) && RawExceptionCheck.isNotMainMethod(tree)) {
            for (TypeTree throwClause : tree.throwsClauses()) {
                Type exceptionType = throwClause.symbolType();
                if (!RawExceptionCheck.isRawException(exceptionType) || this.exceptionsThrownByMethodInvocations.contains(exceptionType)) continue;
                this.reportIssue(throwClause);
            }
        }
        this.exceptionsThrownByMethodInvocations.clear();
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        TypeTree exception;
        Type symbolType;
        if (tree.expression().is(Tree.Kind.NEW_CLASS) && RawExceptionCheck.isRawException(symbolType = (exception = ((NewClassTree)tree.expression()).identifier()).symbolType())) {
            this.reportIssue(exception);
        }
        super.visitThrowStatement(tree);
    }

    private void reportIssue(Tree tree) {
        this.context.reportIssue(this, tree, "Define and throw a dedicated exception instead of using a generic one.");
    }

    @Override
    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (tree.symbol().isMethodSymbol()) {
            this.exceptionsThrownByMethodInvocations.addAll(((Symbol.MethodSymbol)tree.symbol()).thrownTypes());
        }
        super.visitMethodInvocation(tree);
    }

    private static boolean isRawException(Type type) {
        for (String rawException : RAW_EXCEPTIONS) {
            if (!type.is(rawException)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotOverridden(MethodTree tree) {
        return Boolean.FALSE.equals(tree.isOverriding());
    }

    private static boolean isNotMainMethod(MethodTree tree) {
        return !MethodTreeUtils.isMainMethod(tree);
    }
}

