/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S2696")
public class StaticFieldUpateCheck
extends AbstractInSynchronizeChecker {
    private static final Tree.Kind[] ASSIGNMENT_EXPRESSIONS = new Tree.Kind[]{Tree.Kind.AND_ASSIGNMENT, Tree.Kind.ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT};
    private static final Tree.Kind[] UNARY_EXPRESSIONS = new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT};
    private Deque<Boolean> withinStaticMethod = new LinkedList<Boolean>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        ArrayList<Tree.Kind> nodesToVisit = new ArrayList<Tree.Kind>(super.nodesToVisit());
        nodesToVisit.add(Tree.Kind.STATIC_INITIALIZER);
        nodesToVisit.addAll(Arrays.asList(ASSIGNMENT_EXPRESSIONS));
        nodesToVisit.addAll(Arrays.asList(UNARY_EXPRESSIONS));
        return nodesToVisit;
    }

    @Override
    public void visitNode(Tree tree) {
        super.visitNode(tree);
        if (tree.is(Tree.Kind.METHOD)) {
            this.withinStaticMethod.push(StaticFieldUpateCheck.isMethodStatic((MethodTree)tree));
        } else if (tree.is(Tree.Kind.STATIC_INITIALIZER)) {
            this.withinStaticMethod.push(true);
        } else if (this.isInInstanceMethod() && !this.hasAnyParentStatic() && !this.hasAnyParentSync()) {
            if (tree.is(ASSIGNMENT_EXPRESSIONS)) {
                this.checkVariableModification(((AssignmentExpressionTree)tree).variable());
            } else if (tree.is(UNARY_EXPRESSIONS)) {
                this.checkVariableModification(((UnaryExpressionTree)tree).expression());
            }
        }
    }

    private boolean hasAnyParentStatic() {
        return this.withinStaticMethod.contains(true);
    }

    private boolean isInInstanceMethod() {
        return !this.withinStaticMethod.isEmpty() && this.withinStaticMethod.peek() == false;
    }

    private static boolean isMethodStatic(MethodTree tree) {
        return ModifiersUtils.hasModifier(tree.modifiers(), Modifier.STATIC);
    }

    @Override
    public void leaveNode(Tree tree) {
        super.leaveNode(tree);
        if (tree.is(Tree.Kind.METHOD, Tree.Kind.STATIC_INITIALIZER)) {
            this.withinStaticMethod.pop();
        }
    }

    private void checkVariableModification(ExpressionTree expression) {
        if (expression.is(Tree.Kind.IDENTIFIER)) {
            this.checkFieldModification((IdentifierTree)expression);
        } else if (expression.is(Tree.Kind.MEMBER_SELECT)) {
            this.checkFieldModification(((MemberSelectExpressionTree)expression).identifier());
        } else if (expression.is(Tree.Kind.ARRAY_ACCESS_EXPRESSION)) {
            this.checkVariableModification(((ArrayAccessExpressionTree)expression).expression());
        }
    }

    private void checkFieldModification(IdentifierTree identifier) {
        Symbol variable = identifier.symbol();
        if (StaticFieldUpateCheck.isStaticField(variable)) {
            this.reportIssue(identifier, "Make the enclosing method \"static\" or remove this set.");
        }
    }

    private static boolean isStaticField(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isTypeSymbol() && symbol.isStatic();
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.none();
    }
}

