/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2442")
public class SynchronizedLockCheck
extends IssuableSubscriptionVisitor {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    @Override
    public void visitNode(Tree tree) {
        ExpressionTree expression = ((SynchronizedStatementTree)tree).expression();
        if (expression.symbolType().isSubtypeOf("java.util.concurrent.locks.Lock")) {
            this.reportIssue(expression, "Synchronize on this \"Lock\" object using \"acquire/release\".");
        }
    }
}

