/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1448")
public class TooManyMethodsCheck
extends IssuableSubscriptionVisitor {
    private static final int DEFAULT_MAXIMUM = 35;
    @RuleProperty(key="maximumMethodThreshold", description="The maximum number of methods authorized in a class.", defaultValue="35")
    public int maximumMethodThreshold = 35;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count.", defaultValue="true")
    public boolean countNonPublic = true;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE);
    }

    @Override
    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        List<Tree> methods = classTree.members().stream().filter(member -> member.is(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR) && (this.countNonPublic || ((MethodTree)member).symbol().isPublic())).collect(Collectors.toList());
        if (this.shouldNotReportIssue(classTree, methods)) {
            return;
        }
        List<JavaFileScannerContext.Location> secondary = methods.stream().map(element -> new JavaFileScannerContext.Location("Method + 1", (Tree)element)).collect(Collectors.toList());
        String classDescription = classTree.simpleName() == null ? "Anonymous class \"" + ((NewClassTree)classTree.parent()).identifier().symbolType().name() + "\"" : classTree.declarationKeyword().text() + " \"" + classTree.simpleName() + "\"";
        this.reportIssue(ExpressionsHelper.reportOnClassTree(classTree), String.format("%s has %d%s methods, which is greater than the %d authorized. Split it into smaller classes.", classDescription, methods.size(), this.countNonPublic ? "" : " public", this.maximumMethodThreshold), secondary, null);
    }

    private boolean shouldNotReportIssue(ClassTree classTree, List<Tree> methods) {
        return classTree.simpleName() == null && methods.stream().allMatch(member -> ((MethodTree)member).isOverriding()) || methods.size() <= this.maximumMethodThreshold;
    }
}

