/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

class SignatureUtils {
    private static final String VOID = "V";
    private static final String BOOLEAN = "Z";

    private SignatureUtils() {
    }

    static boolean isConstructor(String signature) {
        return signature.contains("<init>");
    }

    static int numberOfArguments(String signature) {
        return SignatureUtils.argumentTypes(signature).length;
    }

    static boolean isVoidMethod(String signature) {
        return VOID.equals(SignatureUtils.returnType(signature));
    }

    static boolean isBoolean(String signature, int argumentIndex) {
        String type;
        if (argumentIndex == -1) {
            type = SignatureUtils.returnType(signature);
        } else {
            String[] argumentTypes = SignatureUtils.argumentTypes(signature);
            type = argumentTypes[argumentIndex];
        }
        return BOOLEAN.equals(type);
    }

    private static String returnType(String signature) {
        return SignatureUtils.getReturnType(SignatureUtils.methodDescriptor(signature));
    }

    private static String[] argumentTypes(String signature) {
        return SignatureUtils.getArgumentTypes(SignatureUtils.methodDescriptor(signature));
    }

    private static String methodDescriptor(String signature) {
        return signature.substring(signature.indexOf(40));
    }

    private static String[] getArgumentTypes(String methodDescriptor) {
        int numArgumentTypes = 0;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            ++numArgumentTypes;
        }
        String[] argumentTypes = new String[numArgumentTypes];
        currentOffset = 1;
        int currentArgumentTypeIndex = 0;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            argumentTypes[currentArgumentTypeIndex++] = methodDescriptor.substring(currentArgumentTypeOffset, currentOffset);
        }
        return argumentTypes;
    }

    private static String getReturnType(String methodDescriptor) {
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) != 'L') continue;
            int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
            currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
        }
        return methodDescriptor.substring(currentOffset + 1);
    }
}

